
package org.glassfish.jersey.microprofile.restclient.internal;

import java.util.Locale;
import java.util.ResourceBundle;
import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory.ResourceBundleSupplier;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static String BUNDLE_NAME = "org.glassfish.jersey.microprofile.restclient.internal.localization";
    private final static LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new LocalizationMessages.BundleSupplier());
    private final static Localizer LOCALIZER = new Localizer();

    public static Localizable localizableWARN_VERSION_14_PROXY() {
        return MESSAGE_FACTORY.getMessage("warn.version14.proxy");
    }

    /**
     * MP Rest Client Version 1.4 does not support RestClientBuilder#proxy and it is ignored.
     * 
     */
    public static String WARN_VERSION_14_PROXY() {
        return LOCALIZER.localize(localizableWARN_VERSION_14_PROXY());
    }

    public static Localizable localizableWARN_VERSION_14_QUERYPARAMSTYLE() {
        return MESSAGE_FACTORY.getMessage("warn.version14.queryparamstyle");
    }

    /**
     * MP Rest Client Version 1.4 does not support RestClientBuilder#queryParamStyle and it is ignored.
     * 
     */
    public static String WARN_VERSION_14_QUERYPARAMSTYLE() {
        return LOCALIZER.localize(localizableWARN_VERSION_14_QUERYPARAMSTYLE());
    }

    public static Localizable localizableWARN_VERSION_14_FOLLOWREDIRECT() {
        return MESSAGE_FACTORY.getMessage("warn.version14.followredirect");
    }

    /**
     * MP Rest Client Version 1.4 does not support RestClientBuilder#followRedirect and it is ignored.
     * 
     */
    public static String WARN_VERSION_14_FOLLOWREDIRECT() {
        return LOCALIZER.localize(localizableWARN_VERSION_14_FOLLOWREDIRECT());
    }

    public static Localizable localizableERR_INVALID_PROXY_URI(Object arg0) {
        return MESSAGE_FACTORY.getMessage("err.invalid.proxy.uri", arg0);
    }

    /**
     * Invalid proxy URI: {0}.
     * 
     */
    public static String ERR_INVALID_PROXY_URI(Object arg0) {
        return LOCALIZER.localize(localizableERR_INVALID_PROXY_URI(arg0));
    }

    public static Localizable localizableERR_INVALID_PROXY_PORT(Object arg0) {
        return MESSAGE_FACTORY.getMessage("err.invalid.proxy.port", arg0);
    }

    /**
     * Invalid proxy port: {0}.
     * 
     */
    public static String ERR_INVALID_PROXY_PORT(Object arg0) {
        return LOCALIZER.localize(localizableERR_INVALID_PROXY_PORT(arg0));
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
