/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.microprofile.restclient;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;

class ConfigWrapper
implements Configuration {
    private final Configuration jerseyBuilderConfig;
    private final Map<Class<?>, Map<Class<?>, Integer>> customProviders;

    ConfigWrapper(Configuration jerseyBuilderConfig) {
        this.jerseyBuilderConfig = jerseyBuilderConfig;
        this.customProviders = new HashMap();
    }

    void addCustomProvider(Class<?> provider, Map<Class<?>, Integer> contracts) {
        if (this.customProviders.containsKey(provider)) {
            this.customProviders.get(provider).putAll(contracts);
        } else {
            this.customProviders.put(provider, contracts);
        }
    }

    public RuntimeType getRuntimeType() {
        return this.jerseyBuilderConfig.getRuntimeType();
    }

    public Map<String, Object> getProperties() {
        return this.jerseyBuilderConfig.getProperties();
    }

    public Object getProperty(String name) {
        return this.jerseyBuilderConfig.getProperty(name);
    }

    public Collection<String> getPropertyNames() {
        return this.jerseyBuilderConfig.getPropertyNames();
    }

    public boolean isEnabled(Feature feature) {
        return this.jerseyBuilderConfig.isEnabled(feature);
    }

    public boolean isEnabled(Class<? extends Feature> featureClass) {
        return this.jerseyBuilderConfig.isEnabled(featureClass);
    }

    public boolean isRegistered(Object component) {
        return this.jerseyBuilderConfig.isRegistered(component);
    }

    public boolean isRegistered(Class<?> componentClass) {
        return this.jerseyBuilderConfig.isRegistered(componentClass);
    }

    public Map<Class<?>, Integer> getContracts(Class<?> componentClass) {
        HashMap map = new HashMap(this.jerseyBuilderConfig.getContracts(componentClass));
        if (this.customProviders.containsKey(componentClass)) {
            map.putAll(this.customProviders.get(componentClass));
        }
        return map;
    }

    public Set<Class<?>> getClasses() {
        return this.jerseyBuilderConfig.getClasses();
    }

    public Set<Object> getInstances() {
        return this.jerseyBuilderConfig.getInstances();
    }
}

