/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.microprofile.restclient;

import java.util.logging.Logger;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.ext.QueryParamStyle;
import org.glassfish.jersey.internal.util.collection.LazyValue;
import org.glassfish.jersey.internal.util.collection.Values;
import org.glassfish.jersey.microprofile.restclient.internal.LocalizationMessages;

abstract class VersionSupport {
    private static final Logger logger = Logger.getLogger(VersionSupport.class.getName());
    private static LazyValue<VersionSupport> currentVersion = Values.lazy(() -> {
        Class<RestClientBuilder> restClientBuilderClass = RestClientBuilder.class;
        try {
            if (null != restClientBuilderClass.getMethod("followRedirects", Boolean.TYPE)) {
                return new Version20Support();
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return new Version14Support();
    });

    VersionSupport() {
    }

    protected abstract RestClientBuilder _followRedirects(RestClientBuilder var1, boolean var2);

    protected abstract RestClientBuilder _proxyAddress(RestClientBuilder var1, String var2);

    protected abstract RestClientBuilder _queryParamStyle(RestClientBuilder var1, String var2);

    static RestClientBuilder followRedirects(RestClientBuilder restClientBuilder, boolean follow) {
        return ((VersionSupport)currentVersion.get())._followRedirects(restClientBuilder, follow);
    }

    static RestClientBuilder proxyAddress(RestClientBuilder restClientBuilder, String proxy) {
        return ((VersionSupport)currentVersion.get())._proxyAddress(restClientBuilder, proxy);
    }

    static RestClientBuilder queryParamStyle(RestClientBuilder restClientBuilder, String style) {
        return ((VersionSupport)currentVersion.get())._queryParamStyle(restClientBuilder, style);
    }

    private static class Version20Support
    extends VersionSupport {
        private Version20Support() {
        }

        @Override
        protected RestClientBuilder _followRedirects(RestClientBuilder restClientBuilder, boolean follow) {
            return restClientBuilder.followRedirects(follow);
        }

        @Override
        protected RestClientBuilder _proxyAddress(RestClientBuilder restClientBuilder, String proxy) {
            int proxyPort;
            int index = proxy.lastIndexOf(58);
            if (index < 0 || proxy.length() - 1 == index) {
                throw new IllegalArgumentException(LocalizationMessages.ERR_INVALID_PROXY_URI(proxy));
            }
            String proxyHost = proxy.substring(0, index);
            String proxyPortStr = proxy.substring(index + 1);
            try {
                proxyPort = Integer.parseInt(proxyPortStr);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException(LocalizationMessages.ERR_INVALID_PROXY_PORT(proxyPortStr), nfe);
            }
            return restClientBuilder.proxyAddress(proxyHost, proxyPort);
        }

        @Override
        protected RestClientBuilder _queryParamStyle(RestClientBuilder restClientBuilder, String style) {
            QueryParamStyle queryParamStyle = QueryParamStyle.valueOf((String)style);
            return restClientBuilder.queryParamStyle(queryParamStyle);
        }
    }

    private static class Version14Support
    extends VersionSupport {
        private Version14Support() {
        }

        @Override
        protected RestClientBuilder _followRedirects(RestClientBuilder restClientBuilder, boolean follow) {
            logger.warning(LocalizationMessages.WARN_VERSION_14_FOLLOWREDIRECT());
            return restClientBuilder;
        }

        @Override
        protected RestClientBuilder _proxyAddress(RestClientBuilder restClientBuilder, String proxy) {
            logger.warning(LocalizationMessages.WARN_VERSION_14_PROXY());
            return restClientBuilder;
        }

        @Override
        protected RestClientBuilder _queryParamStyle(RestClientBuilder restClientBuilder, String style) {
            logger.warning(LocalizationMessages.WARN_VERSION_14_QUERYPARAMSTYLE());
            return restClientBuilder;
        }
    }
}

