/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.microprofile.restclient;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.interceptor.InvocationContext;
import javax.ws.rs.client.WebTarget;
import org.glassfish.jersey.microprofile.restclient.MethodModel;

class InterceptorInvocationContext
implements InvocationContext {
    private final MethodModel methodModel;
    private final Method method;
    private final Map<String, Object> contextData;
    private final List<InvocationInterceptor> interceptors;
    private final WebTarget classLevelWebTarget;
    private volatile Object[] args;
    private final int currentPosition;

    InterceptorInvocationContext(WebTarget classLevelWebTarget, MethodModel methodModel, Method method, Object[] args) {
        this.currentPosition = 0;
        this.contextData = new HashMap<String, Object>();
        this.methodModel = methodModel;
        this.method = method;
        this.args = args;
        this.classLevelWebTarget = classLevelWebTarget;
        this.interceptors = methodModel.getInvocationInterceptors();
    }

    InterceptorInvocationContext(InterceptorInvocationContext other, int currentPosition) {
        this.currentPosition = currentPosition;
        this.contextData = other.contextData;
        this.methodModel = other.methodModel;
        this.method = other.method;
        this.args = other.args;
        this.classLevelWebTarget = other.classLevelWebTarget;
        this.interceptors = other.interceptors;
    }

    public Object getTarget() {
        return this.methodModel;
    }

    public Object getTimer() {
        return null;
    }

    public Method getMethod() {
        return this.method;
    }

    public Constructor<?> getConstructor() {
        return null;
    }

    public Object[] getParameters() {
        return this.args;
    }

    public void setParameters(Object[] params) {
        this.args = params;
    }

    public Map<String, Object> getContextData() {
        return this.contextData;
    }

    public Object proceed() {
        InterceptorInvocationContext nextContext = new InterceptorInvocationContext(this, this.currentPosition + 1);
        this.contextData.put(this.getClass().getName(), nextContext);
        if (this.currentPosition < this.interceptors.size()) {
            return this.interceptors.get(this.currentPosition).intercept(nextContext);
        }
        return this.methodModel.invokeMethod(this.classLevelWebTarget, this.method, this.args);
    }

    static class InvocationInterceptor {
        private final Object interceptorInstance;
        private final Interceptor interceptor;

        InvocationInterceptor(Object interceptorInstance, Interceptor interceptor) {
            this.interceptorInstance = interceptorInstance;
            this.interceptor = interceptor;
        }

        Object intercept(InvocationContext ctx) {
            try {
                return this.interceptor.intercept(InterceptionType.AROUND_INVOKE, this.interceptorInstance, ctx);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
    }
}

