/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.microprofile.restclient;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.microprofile.restclient.InterfaceModel;
import org.glassfish.jersey.microprofile.restclient.ParamModel;
import org.glassfish.jersey.model.Parameter;

class BeanClassModel {
    private final Class<?> beanClass;
    private final List<ParamModel> parameterModels;

    static BeanClassModel fromClass(InterfaceModel interfaceModel, Class<?> beanClass) {
        return new Builder(interfaceModel, beanClass).build();
    }

    private BeanClassModel(Builder builder) {
        this.beanClass = builder.beanClass;
        this.parameterModels = builder.parameterModels;
    }

    List<ParamModel> getParameterModels() {
        return this.parameterModels;
    }

    WebTarget resolvePath(WebTarget webTarget, Object instance) {
        AtomicReference<WebTarget> toReturn = new AtomicReference<WebTarget>(webTarget);
        this.parameterModels.stream().filter(paramModel -> paramModel.handles(PathParam.class)).forEach(parameterModel -> {
            Field field = (Field)parameterModel.getAnnotatedElement();
            toReturn.set(parameterModel.handleParameter(webTarget, PathParam.class, this.resolveValueFromField(field, instance)));
        });
        return toReturn.get();
    }

    MultivaluedMap<String, Object> resolveHeaders(MultivaluedMap<String, Object> headers, Object instance) {
        this.parameterModels.stream().filter(paramModel -> paramModel.handles(HeaderParam.class)).forEach(parameterModel -> {
            Field field = (Field)parameterModel.getAnnotatedElement();
            parameterModel.handleParameter(headers, HeaderParam.class, this.resolveValueFromField(field, instance));
        });
        return headers;
    }

    Map<String, String> resolveCookies(Map<String, String> cookies, Object instance) {
        this.parameterModels.stream().filter(paramModel -> paramModel.handles(CookieParam.class)).forEach(parameterModel -> {
            Field field = (Field)parameterModel.getAnnotatedElement();
            parameterModel.handleParameter(cookies, CookieParam.class, this.resolveValueFromField(field, instance));
        });
        return cookies;
    }

    Map<String, Object[]> resolveQuery(Map<String, Object[]> query, Object instance) {
        this.parameterModels.stream().filter(paramModel -> paramModel.handles(QueryParam.class)).forEach(parameterModel -> {
            Field field = (Field)parameterModel.getAnnotatedElement();
            parameterModel.handleParameter(query, QueryParam.class, this.resolveValueFromField(field, instance));
        });
        return query;
    }

    WebTarget resolveMatrix(WebTarget webTarget, Object instance) {
        AtomicReference<WebTarget> toReturn = new AtomicReference<WebTarget>(webTarget);
        this.parameterModels.stream().filter(paramModel -> paramModel.handles(MatrixParam.class)).forEach(parameterModel -> {
            Field field = (Field)parameterModel.getAnnotatedElement();
            toReturn.set(parameterModel.handleParameter(webTarget, MatrixParam.class, this.resolveValueFromField(field, instance)));
        });
        return toReturn.get();
    }

    Form resolveForm(Form form, Object instance) {
        this.parameterModels.stream().filter(paramModel -> paramModel.handles(FormParam.class)).forEach(parameterModel -> {
            Field field = (Field)parameterModel.getAnnotatedElement();
            parameterModel.handleParameter(form, FormParam.class, this.resolveValueFromField(field, instance));
        });
        return form;
    }

    private Object resolveValueFromField(Field field, Object instance) {
        return AccessController.doPrivileged(() -> {
            try {
                if (field.isAccessible()) {
                    return field.get(instance);
                }
                field.setAccessible(true);
                Object toReturn = field.get(instance);
                field.setAccessible(false);
                return toReturn;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static class Builder {
        private final InterfaceModel interfaceModel;
        private final Class<?> beanClass;
        private ArrayList<ParamModel> parameterModels = new ArrayList();

        private Builder(InterfaceModel interfaceModel, Class<?> beanClass) {
            this.interfaceModel = interfaceModel;
            this.beanClass = beanClass;
        }

        private void processPathFields() {
            this.processFieldsByParameterClass(PathParam.class);
        }

        private void processHeaderFields() {
            this.processFieldsByParameterClass(HeaderParam.class);
        }

        private void processCookieFields() {
            this.processFieldsByParameterClass(CookieParam.class);
        }

        private void processQueryFields() {
            this.processFieldsByParameterClass(QueryParam.class);
        }

        private void processMatrixFields() {
            this.processFieldsByParameterClass(MatrixParam.class);
        }

        private void processFieldsByParameterClass(Class<? extends Annotation> parameterClass) {
            for (Field field : this.beanClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(parameterClass)) continue;
                Parameter parameter = Parameter.create(parameterClass, parameterClass, (boolean)false, field.getType(), (Type)field.getGenericType(), (Annotation[])field.getDeclaredAnnotations());
                this.parameterModels.add(ParamModel.from(this.interfaceModel, field.getType(), field, parameter, -1));
            }
        }

        BeanClassModel build() {
            this.processPathFields();
            this.processHeaderFields();
            this.processCookieFields();
            this.processQueryFields();
            this.processMatrixFields();
            return new BeanClassModel(this);
        }
    }
}

