/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client.rx.rxjava;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.core.GenericType;
import org.glassfish.jersey.client.JerseyInvocation;
import org.glassfish.jersey.client.rx.rxjava.RxObservableInvoker;
import org.glassfish.jersey.client.rx.spi.AbstractRxInvoker;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.schedulers.Schedulers;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.Subscriptions;

final class JerseyRxObservableInvoker
extends AbstractRxInvoker<Observable>
implements RxObservableInvoker {
    JerseyRxObservableInvoker(Invocation.Builder builder, ExecutorService executor) {
        super(builder, executor);
    }

    @Override
    public <T> Observable<T> method(String name, Entity<?> entity, Class<T> responseType) {
        return this.method(name, entity, (GenericType<T>)new GenericType<T>(responseType){});
    }

    @Override
    public <T> Observable<T> method(final String name, final Entity<?> entity, final GenericType<T> responseType) {
        if (this.getExecutorService() == null) {
            return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<T>(){

                public void call(final Subscriber<? super T> subscriber) {
                    CompositeSubscription parent = new CompositeSubscription();
                    subscriber.add((Subscription)parent);
                    JerseyInvocation invocation = (JerseyInvocation)JerseyRxObservableInvoker.this.getBuilder().build(name, entity);
                    parent.add(Subscriptions.from((Future)invocation.submit(responseType, new InvocationCallback<T>(){

                        public void completed(T entity) {
                            if (!subscriber.isUnsubscribed()) {
                                subscriber.onNext(entity);
                            }
                            if (!subscriber.isUnsubscribed()) {
                                subscriber.onCompleted();
                            }
                        }

                        public void failed(Throwable throwable) {
                            if (!subscriber.isUnsubscribed()) {
                                subscriber.onError(throwable);
                            }
                        }
                    })));
                }
            });
        }
        Scheduler scheduler = Schedulers.from((Executor)this.getExecutorService());
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<T>(){

            public void call(Subscriber<? super T> subscriber) {
                block5: {
                    if (!subscriber.isUnsubscribed()) {
                        try {
                            Object response = JerseyRxObservableInvoker.this.getBuilder().method(name, entity, responseType);
                            if (!subscriber.isUnsubscribed()) {
                                subscriber.onNext(response);
                            }
                            if (!subscriber.isUnsubscribed()) {
                                subscriber.onCompleted();
                            }
                        }
                        catch (Throwable throwable) {
                            if (subscriber.isUnsubscribed()) break block5;
                            subscriber.onError(throwable);
                        }
                    }
                }
            }
        }).subscribeOn(scheduler).observeOn(scheduler);
    }
}

