/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client.rx.spi;

import java.util.concurrent.ExecutorService;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.rx.RxInvoker;

public abstract class AbstractRxInvoker<T>
implements RxInvoker<T> {
    private final Invocation.Builder builder;
    private final ExecutorService executorService;

    public AbstractRxInvoker(Invocation.Builder builder, ExecutorService executor) {
        if (builder == null) {
            throw new IllegalArgumentException("Invocation builder cannot be null.");
        }
        this.builder = builder;
        this.executorService = executor;
    }

    protected Invocation.Builder getBuilder() {
        return this.builder;
    }

    protected ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public T get() {
        return this.method("GET");
    }

    @Override
    public <R> T get(Class<R> responseType) {
        return this.method("GET", responseType);
    }

    @Override
    public <R> T get(GenericType<R> responseType) {
        return this.method("GET", responseType);
    }

    @Override
    public T put(Entity<?> entity) {
        return this.method("PUT", entity);
    }

    @Override
    public <R> T put(Entity<?> entity, Class<R> clazz) {
        return this.method("PUT", entity, clazz);
    }

    @Override
    public <R> T put(Entity<?> entity, GenericType<R> type) {
        return this.method("PUT", entity, type);
    }

    @Override
    public T post(Entity<?> entity) {
        return this.method("POST", entity);
    }

    @Override
    public <R> T post(Entity<?> entity, Class<R> clazz) {
        return this.method("POST", entity, clazz);
    }

    @Override
    public <R> T post(Entity<?> entity, GenericType<R> type) {
        return this.method("POST", entity, type);
    }

    @Override
    public T delete() {
        return this.method("DELETE");
    }

    @Override
    public <R> T delete(Class<R> responseType) {
        return this.method("DELETE", responseType);
    }

    @Override
    public <R> T delete(GenericType<R> responseType) {
        return this.method("DELETE", responseType);
    }

    @Override
    public T head() {
        return this.method("HEAD");
    }

    @Override
    public T options() {
        return this.method("OPTIONS");
    }

    @Override
    public <R> T options(Class<R> responseType) {
        return this.method("OPTIONS", responseType);
    }

    @Override
    public <R> T options(GenericType<R> responseType) {
        return this.method("OPTIONS", responseType);
    }

    @Override
    public T trace() {
        return this.method("TRACE");
    }

    @Override
    public <R> T trace(Class<R> responseType) {
        return this.method("TRACE", responseType);
    }

    @Override
    public <R> T trace(GenericType<R> responseType) {
        return this.method("TRACE", responseType);
    }

    @Override
    public T method(String name) {
        return this.method(name, Response.class);
    }

    @Override
    public <R> T method(String name, Class<R> responseType) {
        return this.method(name, null, responseType);
    }

    @Override
    public <R> T method(String name, GenericType<R> responseType) {
        return this.method(name, null, responseType);
    }

    @Override
    public T method(String name, Entity<?> entity) {
        return this.method(name, entity, Response.class);
    }
}

