/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client.rx;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.ws.rs.client.AsyncInvoker;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.rx.RxInvocationBuilder;
import org.glassfish.jersey.client.rx.RxInvoker;
import org.glassfish.jersey.client.rx.spi.RxInvokerProvider;
import org.glassfish.jersey.internal.ServiceFinder;

final class JerseyRxInvocationBuilder<RX extends RxInvoker>
implements RxInvocationBuilder<RX> {
    private static final Set<RxInvokerProvider> INVOKER_PROVIDERS = new HashSet<RxInvokerProvider>();
    private static final Map<Class<? extends RxInvoker>, RxInvokerProvider> PROVIDER_MAP = new IdentityHashMap<Class<? extends RxInvoker>, RxInvokerProvider>();
    private final Class<RX> invokerType;
    private final ExecutorService executor;
    private RX invoker;
    private Invocation.Builder builder;

    JerseyRxInvocationBuilder(Invocation.Builder builder, Class<RX> invokerType, ExecutorService executor) {
        this.builder = builder;
        this.executor = executor;
        this.invokerType = invokerType;
    }

    @Override
    public RX rx() {
        if (this.invoker == null) {
            this.invoker = this.rx(this.invokerType, this.executor);
        }
        return this.invoker;
    }

    @Override
    public RX rx(ExecutorService executorService) {
        return this.rx(this.invokerType, executorService);
    }

    private <CX extends RxInvoker> CX rx(Class<CX> customType, ExecutorService executor) {
        RxInvokerProvider provider = PROVIDER_MAP.get(customType);
        RxInvoker customInvoker = null;
        if (provider == null) {
            for (RxInvokerProvider invokerProvider : INVOKER_PROVIDERS) {
                customInvoker = (RxInvoker)invokerProvider.getInvoker(customType, this.builder, executor);
                if (customInvoker == null) continue;
                PROVIDER_MAP.put(customType, invokerProvider);
                break;
            }
        } else {
            customInvoker = (RxInvoker)provider.getInvoker(customType, this.builder, executor);
        }
        return (CX)((RxInvoker)customType.cast(customInvoker));
    }

    @Override
    public JerseyRxInvocationBuilder<RX> accept(String ... mediaTypes) {
        this.builder = this.builder.accept(mediaTypes);
        return this;
    }

    @Override
    public JerseyRxInvocationBuilder<RX> accept(MediaType ... mediaTypes) {
        this.builder = this.builder.accept(mediaTypes);
        return this;
    }

    @Override
    public JerseyRxInvocationBuilder<RX> acceptLanguage(Locale ... locales) {
        this.builder = this.builder.acceptLanguage(locales);
        return this;
    }

    @Override
    public JerseyRxInvocationBuilder<RX> acceptLanguage(String ... locales) {
        this.builder = this.builder.acceptLanguage(locales);
        return this;
    }

    @Override
    public JerseyRxInvocationBuilder<RX> acceptEncoding(String ... encodings) {
        this.builder = this.builder.acceptEncoding(encodings);
        return this;
    }

    @Override
    public JerseyRxInvocationBuilder<RX> cookie(Cookie cookie) {
        this.builder = this.builder.cookie(cookie);
        return this;
    }

    @Override
    public JerseyRxInvocationBuilder<RX> cookie(String name, String value) {
        this.builder = this.builder.cookie(name, value);
        return this;
    }

    @Override
    public JerseyRxInvocationBuilder<RX> cacheControl(CacheControl cacheControl) {
        this.builder = this.builder.cacheControl(cacheControl);
        return this;
    }

    @Override
    public JerseyRxInvocationBuilder<RX> header(String name, Object value) {
        this.builder = this.builder.header(name, value);
        return this;
    }

    @Override
    public JerseyRxInvocationBuilder<RX> headers(MultivaluedMap<String, Object> headers) {
        this.builder = this.builder.headers(headers);
        return this;
    }

    @Override
    public JerseyRxInvocationBuilder<RX> property(String name, Object value) {
        this.builder = this.builder.property(name, value);
        return this;
    }

    public Response get() {
        return this.builder.get();
    }

    public <T> T get(Class<T> responseType) {
        return (T)this.builder.get(responseType);
    }

    public <T> T get(GenericType<T> responseType) {
        return (T)this.builder.get(responseType);
    }

    public Response put(Entity<?> entity) {
        return this.builder.put(entity);
    }

    public <T> T put(Entity<?> entity, Class<T> responseType) {
        return (T)this.builder.put(entity, responseType);
    }

    public <T> T put(Entity<?> entity, GenericType<T> responseType) {
        return (T)this.builder.put(entity, responseType);
    }

    public Response post(Entity<?> entity) {
        return this.builder.post(entity);
    }

    public <T> T post(Entity<?> entity, Class<T> responseType) {
        return (T)this.builder.post(entity, responseType);
    }

    public <T> T post(Entity<?> entity, GenericType<T> responseType) {
        return (T)this.builder.post(entity, responseType);
    }

    public Response delete() {
        return this.builder.delete();
    }

    public <T> T delete(Class<T> responseType) {
        return (T)this.builder.delete(responseType);
    }

    public <T> T delete(GenericType<T> responseType) {
        return (T)this.builder.delete(responseType);
    }

    public Response head() {
        return this.builder.head();
    }

    public Response options() {
        return this.builder.options();
    }

    public <T> T options(Class<T> responseType) {
        return (T)this.builder.options(responseType);
    }

    public <T> T options(GenericType<T> responseType) {
        return (T)this.builder.options(responseType);
    }

    public Response trace() {
        return this.builder.trace();
    }

    public <T> T trace(Class<T> responseType) {
        return (T)this.builder.trace(responseType);
    }

    public <T> T trace(GenericType<T> responseType) {
        return (T)this.builder.trace(responseType);
    }

    public Response method(String name) {
        return this.builder.method(name);
    }

    public <T> T method(String name, Class<T> responseType) {
        return (T)this.builder.method(name, responseType);
    }

    public <T> T method(String name, GenericType<T> responseType) {
        return (T)this.builder.method(name, responseType);
    }

    public Response method(String name, Entity<?> entity) {
        return this.builder.method(name, entity);
    }

    public <T> T method(String name, Entity<?> entity, Class<T> responseType) {
        return (T)this.builder.method(name, entity, responseType);
    }

    public <T> T method(String name, Entity<?> entity, GenericType<T> responseType) {
        return (T)this.builder.method(name, entity, responseType);
    }

    public Invocation build(String method) {
        return this.builder.build(method);
    }

    public Invocation build(String method, Entity<?> entity) {
        return this.builder.build(method, entity);
    }

    public Invocation buildGet() {
        return this.builder.buildGet();
    }

    public Invocation buildDelete() {
        return this.builder.buildDelete();
    }

    public Invocation buildPost(Entity<?> entity) {
        return this.builder.buildPost(entity);
    }

    public Invocation buildPut(Entity<?> entity) {
        return this.builder.buildPut(entity);
    }

    public AsyncInvoker async() {
        return this.builder.async();
    }

    static {
        for (RxInvokerProvider provider : ServiceFinder.find(RxInvokerProvider.class)) {
            INVOKER_PROVIDERS.add(provider);
        }
    }
}

