/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.weld.internal.managed;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.ws.rs.RuntimeType;
import org.glassfish.jersey.inject.weld.internal.bean.JerseyBean;
import org.glassfish.jersey.inject.weld.internal.inject.InitializableInstanceBinding;
import org.glassfish.jersey.inject.weld.internal.inject.InitializableSupplierInstanceBinding;
import org.glassfish.jersey.inject.weld.internal.inject.MatchableBinding;
import org.glassfish.jersey.inject.weld.internal.injector.JerseyClientCreationalContext;
import org.glassfish.jersey.inject.weld.internal.managed.CdiInjectionManager;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.Binding;
import org.glassfish.jersey.internal.inject.Bindings;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.internal.inject.SupplierClassBinding;
import org.glassfish.jersey.internal.inject.SupplierInstanceBinding;
import org.jboss.weld.contexts.CreationalContextImpl;

public class CdiClientInjectionManager
extends CdiInjectionManager {
    private Map<InitializableInstanceBinding, InitializableInstanceBinding> clientInstanceBindings = new IdentityHashMap<InitializableInstanceBinding, InitializableInstanceBinding>();
    private Map<InitializableSupplierInstanceBinding, InitializableSupplierInstanceBinding> clientSupplierInstanceBindings = new IdentityHashMap<InitializableSupplierInstanceBinding, InitializableSupplierInstanceBinding>();
    private Map<SupplierClassBinding, SupplierClassBinding> clientSupplierClassBinding = new IdentityHashMap<SupplierClassBinding, SupplierClassBinding>();

    public CdiClientInjectionManager(BeanManager beanManager, Binder bindings) {
        super(beanManager, bindings);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void register(Binding binding) {
        if (InstanceBinding.class.isInstance(binding)) {
            Binding preBinding;
            Collection preBindings = this.getBindings().getBindings();
            MatchableBinding.Matching matching = MatchableBinding.Matching.noneMatching();
            Iterator iterator = preBindings.iterator();
            while (!(!iterator.hasNext() || InitializableInstanceBinding.class.isInstance(preBinding = (Binding)iterator.next()) && (matching = matching.better(((InitializableInstanceBinding)preBinding).matches((Binding)((InstanceBinding)binding)))).isBest())) {
            }
            if (!matching.matches()) throw new IllegalStateException("Not initialized " + ((InstanceBinding)binding).getService());
            Object clone = ((InitializableInstanceBinding)matching.getBinding()).clone();
            ((InitializableInstanceBinding)clone).init(((InstanceBinding)binding).getService());
            this.clientInstanceBindings.put((InitializableInstanceBinding)matching.getBinding(), (InitializableInstanceBinding)clone);
            return;
        } else {
            Binding preBinding;
            if (!SupplierInstanceBinding.class.isInstance(binding)) return;
            Collection preBindings = this.getBindings().getBindings();
            MatchableBinding.Matching matching = MatchableBinding.Matching.noneMatching();
            Object clone = preBindings.iterator();
            while (!(!clone.hasNext() || InitializableSupplierInstanceBinding.class.isInstance(preBinding = (Binding)clone.next()) && (matching = matching.better(((InitializableSupplierInstanceBinding)preBinding).matchesContracts(binding))).isBest())) {
            }
            if (!matching.matches()) throw new IllegalStateException("Not initialized " + ((SupplierInstanceBinding)binding).getSupplier());
            clone = ((InitializableSupplierInstanceBinding)matching.getBinding()).clone();
            ((InitializableSupplierInstanceBinding)clone).init(((SupplierInstanceBinding)binding).getSupplier());
            this.clientSupplierInstanceBindings.put((InitializableSupplierInstanceBinding)matching.getBinding(), (InitializableSupplierInstanceBinding)clone);
        }
    }

    public InitializableInstanceBinding getInjectionManagerBinding(InitializableInstanceBinding binding) {
        InitializableInstanceBinding clientBinding = this.clientInstanceBindings.get(binding);
        return clientBinding != null ? clientBinding : binding;
    }

    public InitializableSupplierInstanceBinding getInjectionManagerBinding(InitializableSupplierInstanceBinding binding) {
        InitializableSupplierInstanceBinding clientBinding = this.clientSupplierInstanceBindings.get(binding);
        return clientBinding != null ? clientBinding : binding;
    }

    public SupplierClassBinding getInjectionManagerBinding(SupplierClassBinding binding) {
        SupplierClassBinding clientBinding = this.clientSupplierClassBinding.get(binding);
        return clientBinding;
    }

    @Override
    public void shutdown() {
        this.clientInstanceBindings.clear();
    }

    @Override
    protected <T> CreationalContext<T> createCreationalContext(Bean<T> bean) {
        JerseyClientCreationalContext ctx = new JerseyClientCreationalContext((CreationalContextImpl)super.createCreationalContext(bean)).setInjectionManager(this);
        return ctx;
    }

    @Override
    public void completeRegistration() throws IllegalStateException {
        this.register(Bindings.service((Object)this).to(InjectionManager.class));
    }

    @Override
    protected boolean isRuntimeTypeBean(Bean<?> bean) {
        return !JerseyBean.class.isInstance(bean) || ((JerseyBean)bean).getRutimeType() == RuntimeType.CLIENT;
    }
}

