/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.weld.internal.injector;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.glassfish.jersey.inject.weld.internal.type.GenericArrayTypeImpl;
import org.glassfish.jersey.inject.weld.internal.type.ParameterizedTypeImpl;
import org.glassfish.jersey.internal.util.collection.ImmutableCollectors;

class ReflectionUtils {
    private static final Logger LOGGER = Logger.getLogger(ReflectionUtils.class.getName());

    ReflectionUtils() {
    }

    static Set<Field> getAllFields(Class<?> clazz) {
        if (clazz == null || Object.class.equals(clazz)) {
            return Collections.emptySet();
        }
        if (clazz.isInterface()) {
            return Collections.emptySet();
        }
        LinkedHashSet<Field> retVal = new LinkedHashSet<Field>();
        retVal.addAll(ReflectionUtils.getDeclaredField(clazz));
        retVal.addAll(ReflectionUtils.getAllFields(clazz.getSuperclass()));
        return retVal;
    }

    private static Set<Field> getDeclaredField(Class<?> clazz) {
        return (Set)Arrays.stream(ReflectionUtils.secureGetDeclaredFields(clazz)).collect(ImmutableCollectors.toImmutableLinkedSet());
    }

    private static Field[] secureGetDeclaredFields(Class<?> clazz) {
        return AccessController.doPrivileged(clazz::getDeclaredFields);
    }

    static Type resolveField(Class<?> topclass, Field field) {
        return ReflectionUtils.resolveMember(topclass, field.getGenericType(), field.getDeclaringClass());
    }

    private static Type resolveMember(Class<?> topclass, Type lookingForType, Class<?> declaringClass) {
        Map<String, Type> typeArguments = ReflectionUtils.typesFromSubClassToDeclaringClass(topclass, declaringClass);
        if (typeArguments == null) {
            return lookingForType;
        }
        if (lookingForType instanceof ParameterizedType) {
            return ReflectionUtils.fixTypeVariables((ParameterizedType)lookingForType, typeArguments);
        }
        if (lookingForType instanceof GenericArrayType) {
            return ReflectionUtils.fixGenericArrayTypeVariables((GenericArrayType)lookingForType, typeArguments);
        }
        if (!(lookingForType instanceof TypeVariable)) {
            return lookingForType;
        }
        TypeVariable tv = (TypeVariable)lookingForType;
        String typeVariableName = tv.getName();
        Type retVal = typeArguments.get(typeVariableName);
        if (retVal == null) {
            return lookingForType;
        }
        if (retVal instanceof Class) {
            return retVal;
        }
        if (retVal instanceof ParameterizedType) {
            return ReflectionUtils.fixTypeVariables((ParameterizedType)retVal, typeArguments);
        }
        if (retVal instanceof GenericArrayType) {
            return ReflectionUtils.fixGenericArrayTypeVariables((GenericArrayType)retVal, typeArguments);
        }
        return retVal;
    }

    private static Map<String, Type> typesFromSubClassToDeclaringClass(Class<?> topClass, Class<?> declaringClass) {
        if (topClass.equals(declaringClass)) {
            return null;
        }
        Type superType = topClass.getGenericSuperclass();
        Class<?> superClass = ReflectionUtils.getRawClass(superType);
        while (superType != null && superClass != null) {
            if (!(superType instanceof ParameterizedType)) {
                if (superClass.equals(declaringClass)) {
                    return null;
                }
                superType = superClass.getGenericSuperclass();
                superClass = ReflectionUtils.getRawClass(superType);
                continue;
            }
            ParameterizedType superPT = (ParameterizedType)superType;
            Map<String, Type> typeArguments = ReflectionUtils.getTypeArguments(superClass, superPT);
            if (superClass.equals(declaringClass)) {
                return typeArguments;
            }
            superType = superClass.getGenericSuperclass();
            superClass = ReflectionUtils.getRawClass(superType);
            if (!(superType instanceof ParameterizedType)) continue;
            superType = ReflectionUtils.fixTypeVariables((ParameterizedType)superType, typeArguments);
        }
        throw new AssertionError((Object)(topClass.getName() + " is not the same as or a subclass of " + declaringClass.getName()));
    }

    private static Map<String, Type> getTypeArguments(Class<?> rawClass, ParameterizedType type) {
        HashMap<String, Type> typeMap = new HashMap<String, Type>();
        Type[] typeArguments = type.getActualTypeArguments();
        int i = 0;
        for (TypeVariable<Class<?>> typeVariable : rawClass.getTypeParameters()) {
            typeMap.put(typeVariable.getName(), typeArguments[i++]);
        }
        return typeMap;
    }

    private static Type fixTypeVariables(ParameterizedType type, Map<String, Type> typeArgumentsMap) {
        Type[] newTypeArguments = ReflectionUtils.getNewTypeArguments(type, typeArgumentsMap);
        if (newTypeArguments != null) {
            return new ParameterizedTypeImpl(type.getRawType(), newTypeArguments);
        }
        return type;
    }

    private static Type[] getNewTypeArguments(ParameterizedType type, Map<String, Type> typeArgumentsMap) {
        Type[] typeArguments = type.getActualTypeArguments();
        Type[] newTypeArguments = new Type[typeArguments.length];
        boolean newArgsNeeded = false;
        int i = 0;
        for (Type argType : typeArguments) {
            if (argType instanceof TypeVariable) {
                newTypeArguments[i] = typeArgumentsMap.get(((TypeVariable)argType).getName());
                newArgsNeeded = true;
            } else if (argType instanceof ParameterizedType) {
                ParameterizedType original = (ParameterizedType)argType;
                Type[] internalTypeArgs = ReflectionUtils.getNewTypeArguments(original, typeArgumentsMap);
                if (internalTypeArgs != null) {
                    newTypeArguments[i] = new ParameterizedTypeImpl(original.getRawType(), internalTypeArgs);
                    newArgsNeeded = true;
                } else {
                    newTypeArguments[i] = argType;
                }
            } else if (argType instanceof GenericArrayType) {
                GenericArrayType gat = (GenericArrayType)argType;
                Type internalTypeArg = ReflectionUtils.getNewTypeArrayArguments(gat, typeArgumentsMap);
                if (internalTypeArg != null) {
                    if (internalTypeArg instanceof Class) {
                        newTypeArguments[i] = ReflectionUtils.getArrayOfType((Class)internalTypeArg);
                        newArgsNeeded = true;
                    } else if (internalTypeArg instanceof ParameterizedType && ((ParameterizedType)internalTypeArg).getRawType() instanceof Class) {
                        ParameterizedType pt = (ParameterizedType)internalTypeArg;
                        newTypeArguments[i] = ReflectionUtils.getArrayOfType((Class)pt.getRawType());
                        newArgsNeeded = true;
                    } else {
                        newTypeArguments[i] = new GenericArrayTypeImpl(internalTypeArg);
                        newArgsNeeded = true;
                    }
                } else {
                    newTypeArguments[i] = argType;
                }
            } else {
                newTypeArguments[i] = argType;
            }
            ++i;
        }
        return newArgsNeeded ? newTypeArguments : null;
    }

    private static Type getNewTypeArrayArguments(GenericArrayType gat, Map<String, Type> typeArgumentsMap) {
        Type typeArgument = gat.getGenericComponentType();
        if (typeArgument instanceof TypeVariable) {
            return typeArgumentsMap.get(((TypeVariable)typeArgument).getName());
        }
        if (typeArgument instanceof ParameterizedType) {
            ParameterizedType original = (ParameterizedType)typeArgument;
            Type[] internalTypeArgs = ReflectionUtils.getNewTypeArguments(original, typeArgumentsMap);
            if (internalTypeArgs != null) {
                return new ParameterizedTypeImpl(original.getRawType(), internalTypeArgs);
            }
            return original;
        }
        if (typeArgument instanceof GenericArrayType) {
            GenericArrayType original = (GenericArrayType)typeArgument;
            Type internalTypeArg = ReflectionUtils.getNewTypeArrayArguments(original, typeArgumentsMap);
            if (internalTypeArg != null) {
                ParameterizedType pt;
                if (internalTypeArg instanceof Class) {
                    return ReflectionUtils.getArrayOfType((Class)internalTypeArg);
                }
                if (internalTypeArg instanceof ParameterizedType && (pt = (ParameterizedType)internalTypeArg).getRawType() instanceof Class) {
                    return ReflectionUtils.getArrayOfType((Class)pt.getRawType());
                }
                return new GenericArrayTypeImpl(internalTypeArg);
            }
            return null;
        }
        return null;
    }

    private static Type fixGenericArrayTypeVariables(GenericArrayType type, Map<String, Type> typeArgumentsMap) {
        Type newTypeArgument = ReflectionUtils.getNewTypeArrayArguments(type, typeArgumentsMap);
        if (newTypeArgument != null) {
            ParameterizedType pt;
            if (newTypeArgument instanceof Class) {
                return ReflectionUtils.getArrayOfType((Class)newTypeArgument);
            }
            if (newTypeArgument instanceof ParameterizedType && (pt = (ParameterizedType)newTypeArgument).getRawType() instanceof Class) {
                return ReflectionUtils.getArrayOfType((Class)pt.getRawType());
            }
            return new GenericArrayTypeImpl(newTypeArgument);
        }
        return type;
    }

    private static Class<?> getArrayOfType(Class<?> type) {
        return Array.newInstance(type, 0).getClass();
    }

    private static Class<?> getRawClass(Type type) {
        Type rawType;
        if (type == null) {
            return null;
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            if (!(componentType instanceof ParameterizedType) && !(componentType instanceof Class)) {
                return null;
            }
            Class<?> rawComponentClass = ReflectionUtils.getRawClass(componentType);
            String forNameName = "[L" + rawComponentClass.getName() + ";";
            try {
                return Class.forName(forNameName);
            }
            catch (Throwable th) {
                return null;
            }
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType && (rawType = ((ParameterizedType)type).getRawType()) instanceof Class) {
            return (Class)rawType;
        }
        return null;
    }

    static void setField(Field field, Object instance, Object value) throws Throwable {
        ReflectionUtils.setAccessible(field);
        try {
            field.set(instance, value);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            LOGGER.warning(String.format("Failed during setting a value into Class: %s, Field: %s", field.getDeclaringClass().getName(), field.getName()));
            throw ex;
        }
    }

    private static void setAccessible(AccessibleObject ao) {
        if (ao.isAccessible()) {
            return;
        }
        AccessController.doPrivileged(() -> {
            ao.setAccessible(true);
            return null;
        });
    }
}

