/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.weld.internal.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InjectionTargetFactory;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import javax.ws.rs.RuntimeType;
import org.glassfish.jersey.inject.weld.internal.bean.ClassBean;
import org.glassfish.jersey.inject.weld.internal.bean.InitializableInstanceBean;
import org.glassfish.jersey.inject.weld.internal.bean.InitializableSupplierInstanceBean;
import org.glassfish.jersey.inject.weld.internal.bean.InitializableSupplierInstanceBeanBridge;
import org.glassfish.jersey.inject.weld.internal.bean.InitializableSupplierThreadScopeBean;
import org.glassfish.jersey.inject.weld.internal.bean.JerseyBean;
import org.glassfish.jersey.inject.weld.internal.bean.SupplierBeanBridge;
import org.glassfish.jersey.inject.weld.internal.bean.SupplierClassBean;
import org.glassfish.jersey.inject.weld.internal.data.BindingBeanPair;
import org.glassfish.jersey.inject.weld.internal.inject.InitializableInstanceBinding;
import org.glassfish.jersey.inject.weld.internal.inject.InitializableSupplierInstanceBinding;
import org.glassfish.jersey.inject.weld.internal.injector.CachedConstructorAnalyzer;
import org.glassfish.jersey.inject.weld.internal.injector.InjectionUtils;
import org.glassfish.jersey.inject.weld.internal.injector.JerseyConstructorInjectionPoint;
import org.glassfish.jersey.inject.weld.internal.injector.JerseyInjectionTarget;
import org.glassfish.jersey.inject.weld.internal.injector.JerseyTwofoldInstantiator;
import org.glassfish.jersey.inject.weld.internal.injector.WrappingJerseyInjectionTarget;
import org.glassfish.jersey.internal.inject.Binding;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.glassfish.jersey.internal.inject.InjectionResolver;
import org.glassfish.jersey.internal.inject.PerThread;
import org.glassfish.jersey.internal.inject.SupplierClassBinding;
import org.jboss.weld.annotated.enhanced.ConstructorSignature;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedConstructor;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.enhanced.jlr.ConstructorSignatureImpl;
import org.jboss.weld.annotated.enhanced.jlr.EnhancedAnnotatedTypeImpl;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.injection.ConstructorInjectionPoint;
import org.jboss.weld.injection.producer.AbstractInstantiator;
import org.jboss.weld.injection.producer.BasicInjectionTarget;
import org.jboss.weld.injection.producer.BeanInjectionTarget;
import org.jboss.weld.injection.producer.InjectionTargetService;
import org.jboss.weld.injection.producer.Instantiator;
import org.jboss.weld.injection.producer.NonProducibleInjectionTarget;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;

public abstract class BeanHelper {
    private BeanHelper() {
    }

    public static <T> void registerBean(RuntimeType runtimeType, InitializableInstanceBinding<T> binding, AfterBeanDiscovery abd, List<InjectionResolver> resolvers, BeanManager beanManager) {
        InitializableInstanceBean<T> bean = new InitializableInstanceBean<T>(runtimeType, binding);
        WrappingJerseyInjectionTarget<T> injectionTarget = new WrappingJerseyInjectionTarget<T>(bean, resolvers);
        bean.setInjectionTarget(injectionTarget);
        abd.addBean(bean);
    }

    public static <T> BindingBeanPair registerBean(RuntimeType runtimeType, ClassBinding<T> binding, AfterBeanDiscovery abd, Collection<InjectionResolver> resolvers, BeanManager beanManager) {
        AnnotatedType annotatedType = beanManager.createAnnotatedType(binding.getService());
        InjectionTargetFactory injectionTargetFactory = beanManager.getInjectionTargetFactory(annotatedType);
        InjectionTarget injectionTarget = injectionTargetFactory.createInjectionTarget(null);
        ClassBean<T> bean = new ClassBean<T>(runtimeType, binding);
        bean.setInjectionTarget(BeanHelper.getJerseyInjectionTarget(binding.getService(), injectionTarget, bean, resolvers));
        abd.addBean(bean);
        return new BindingBeanPair((Binding)binding, bean);
    }

    public static <T> void registerSupplier(RuntimeType runtimeType, InitializableSupplierInstanceBinding<T> binding, AfterBeanDiscovery abd, BeanManager beanManager) {
        if (binding.getScope() == PerThread.class) {
            BeanManagerImpl manager = beanManager instanceof BeanManagerProxy ? ((BeanManagerProxy)beanManager).unwrap() : (BeanManagerImpl)beanManager;
            abd.addBean((Bean)new InitializableSupplierThreadScopeBean(runtimeType, binding, manager));
        } else {
            abd.addBean(new InitializableSupplierInstanceBean<T>(runtimeType, binding));
            abd.addBean(new InitializableSupplierInstanceBeanBridge(runtimeType, binding));
        }
    }

    public static <T> BindingBeanPair registerSupplier(RuntimeType runtimeType, SupplierClassBinding<T> binding, AfterBeanDiscovery abd, Collection<InjectionResolver> resolvers, BeanManager beanManager) {
        Class supplierClass = binding.getSupplierClass();
        AnnotatedType annotatedType = beanManager.createAnnotatedType(supplierClass);
        InjectionTarget injectionTarget = beanManager.createInjectionTarget(annotatedType);
        SupplierClassBean<T> supplierBean = new SupplierClassBean<T>(runtimeType, binding);
        InjectionTarget<T> jit = BeanHelper.getJerseyInjectionTarget(supplierClass, injectionTarget, supplierBean, resolvers);
        supplierBean.setInjectionTarget(jit);
        SupplierBeanBridge supplierBeanBridge = new SupplierBeanBridge(runtimeType, binding, beanManager);
        abd.addBean(supplierBean);
        abd.addBean((Bean)supplierBeanBridge);
        return new BindingBeanPair((Binding)binding, supplierBean, supplierBeanBridge);
    }

    public static void updateBean(ClassBinding binding, BindingBeanPair pair, Collection<InjectionResolver> resolvers, BeanManager beanManager) {
        JerseyBean bean = pair.getBeans().get(0);
        ConstructorInjectionPoint cip = BeanHelper.createConstructorInjectionPoint(binding, bean, resolvers, beanManager);
        if (ClassBean.class.isInstance(bean) && JerseyInjectionTarget.class.isInstance(((ClassBean)bean).getInjectionTarget())) {
            JerseyTwofoldInstantiator instantiator = ((JerseyInjectionTarget)((ClassBean)bean).getInjectionTarget()).getTwofoldInstantiator();
            instantiator.setOptionalConstructorInjectionPoint(cip);
        }
    }

    public static void updateSupplierBean(SupplierClassBinding binding, BindingBeanPair pair, Collection<InjectionResolver> resolvers, BeanManager beanManager) {
        JerseyBean bean = pair.getBeans().get(0);
        ConstructorInjectionPoint cip = BeanHelper.createConstructorInjectionPoint(binding, bean, resolvers, beanManager);
        if (SupplierClassBean.class.isInstance(bean) && JerseyInjectionTarget.class.isInstance(((SupplierClassBean)bean).getInjectionTarget())) {
            JerseyTwofoldInstantiator instantiator = ((JerseyInjectionTarget)((SupplierClassBean)bean).getInjectionTarget()).getTwofoldInstantiator();
            instantiator.setOptionalConstructorInjectionPoint(cip);
        }
    }

    private static <T> ConstructorInjectionPoint<T> createConstructorInjectionPoint(SupplierClassBinding<T> binding, Bean<T> bean, Collection<InjectionResolver> resolvers, BeanManager beanManager) {
        Class bindingClass = binding.getSupplierClass();
        AnnotatedType annotatedType = beanManager.createAnnotatedType(bindingClass);
        InjectionTarget injectionTarget = beanManager.createInjectionTarget(annotatedType);
        CachedConstructorAnalyzer analyzer = new CachedConstructorAnalyzer(bindingClass, InjectionUtils.getInjectAnnotations(resolvers));
        if (analyzer.hasCompatibleConstructor()) {
            EnhancedAnnotatedConstructor constructor = BeanHelper.createEnhancedAnnotatedType((BasicInjectionTarget)injectionTarget).getDeclaredEnhancedConstructor((ConstructorSignature)new ConstructorSignatureImpl(analyzer.getConstructor()));
            JerseyConstructorInjectionPoint<T> constructorInjectionPoint = new JerseyConstructorInjectionPoint<T>(constructor, bean, ((BasicInjectionTarget)injectionTarget).getBeanManager(), resolvers);
            return constructorInjectionPoint;
        }
        return null;
    }

    private static <T> ConstructorInjectionPoint<T> createConstructorInjectionPoint(ClassBinding<T> binding, Bean<T> bean, Collection<InjectionResolver> resolvers, BeanManager beanManager) {
        Class bindingClass = binding.getImplementationType();
        AnnotatedType annotatedType = beanManager.createAnnotatedType(bindingClass);
        InjectionTarget injectionTarget = beanManager.createInjectionTarget(annotatedType);
        CachedConstructorAnalyzer analyzer = new CachedConstructorAnalyzer(bindingClass, InjectionUtils.getInjectAnnotations(resolvers));
        if (analyzer.hasCompatibleConstructor()) {
            EnhancedAnnotatedConstructor constructor = BeanHelper.createEnhancedAnnotatedType((BasicInjectionTarget)injectionTarget).getDeclaredEnhancedConstructor((ConstructorSignature)new ConstructorSignatureImpl(analyzer.getConstructor()));
            JerseyConstructorInjectionPoint<T> constructorInjectionPoint = new JerseyConstructorInjectionPoint<T>(constructor, bean, ((BasicInjectionTarget)injectionTarget).getBeanManager(), resolvers);
            return constructorInjectionPoint;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T> InjectionTarget<T> getJerseyInjectionTarget(Class<T> clazz, InjectionTarget<T> injectionTarget, Bean<T> bean, Collection<InjectionResolver> resolvers) {
        JerseyInjectionTarget<T> jit;
        BasicInjectionTarget it = (BasicInjectionTarget)injectionTarget;
        boolean noArgConstructor = BeanHelper.isNoArgConstructorCase(it, clazz);
        if (!noArgConstructor && injectionTarget instanceof BeanInjectionTarget) {
            jit = new JerseyInjectionTarget<T>(it, bean, clazz, resolvers);
        } else {
            if (!noArgConstructor && !(injectionTarget instanceof NonProducibleInjectionTarget)) throw new RuntimeException("Unknown InjectionTarget for the class: " + clazz.getTypeName());
            CachedConstructorAnalyzer<T> analyzer = new CachedConstructorAnalyzer<T>(clazz, InjectionUtils.getInjectAnnotations(resolvers));
            if (!analyzer.hasCompatibleConstructor()) return new WrappingJerseyInjectionTarget<T>(it, bean, resolvers);
            EnhancedAnnotatedConstructor constructor = BeanHelper.createEnhancedAnnotatedType(it).getDeclaredEnhancedConstructor((ConstructorSignature)new ConstructorSignatureImpl(analyzer.getConstructor()));
            JerseyConstructorInjectionPoint<T> constructorInjectionPoint = new JerseyConstructorInjectionPoint<T>(constructor, bean, it.getBeanManager(), resolvers);
            JerseyInstantiator instantiator = new JerseyInstantiator(constructorInjectionPoint);
            jit = new JerseyInjectionTarget<T>(BeanHelper.createEnhancedAnnotatedType(it), it, bean, clazz, resolvers, instantiator);
        }
        InjectionTargetService injectionTargetService = (InjectionTargetService)it.getBeanManager().getServices().get(InjectionTargetService.class);
        injectionTargetService.addInjectionTargetToBeInitialized(jit.getEnhancedAnnotatedType(), jit);
        return jit;
    }

    public static <T> EnhancedAnnotatedType<T> createEnhancedAnnotatedType(BasicInjectionTarget<T> it) {
        return EnhancedAnnotatedTypeImpl.of((SlimAnnotatedType)((SlimAnnotatedType)it.getAnnotatedType()), (ClassTransformer)ClassTransformer.instance((BeanManagerImpl)it.getBeanManager()));
    }

    private static <T> boolean isNoArgConstructorCase(BasicInjectionTarget<T> it, Class<T> clazz) {
        if (!(it instanceof NonProducibleInjectionTarget)) {
            Instantiator instantiator = it.getInstantiator();
            Constructor constructor = instantiator.getConstructor();
            return constructor.getParameterCount() == 0 && clazz.getConstructors().length > 1;
        }
        return false;
    }

    public static boolean isResourceClass(Class<?> clazz) {
        if (BeanHelper.isJaxrsResource(clazz)) {
            return true;
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            if (!BeanHelper.isJaxrsResource(iface)) continue;
            return true;
        }
        return false;
    }

    private static boolean isJaxrsResource(Class<?> clazz) {
        if (clazz.isAnnotationPresent(Path.class)) {
            return true;
        }
        for (Method method : clazz.getMethods()) {
            if (method.isAnnotationPresent(Path.class)) {
                return true;
            }
            for (Annotation annotation : method.getAnnotations()) {
                if (!annotation.annotationType().isAnnotationPresent(HttpMethod.class)) continue;
                return true;
            }
        }
        return false;
    }

    private static class JerseyInstantiator<T>
    extends AbstractInstantiator<T> {
        private final ConstructorInjectionPoint<T> injectionPoint;

        private JerseyInstantiator(ConstructorInjectionPoint<T> injectionPoint) {
            this.injectionPoint = injectionPoint;
        }

        public ConstructorInjectionPoint<T> getConstructorInjectionPoint() {
            return this.injectionPoint;
        }

        public Constructor<T> getConstructor() {
            return this.injectionPoint.getAnnotated().getJavaMember();
        }

        public String toString() {
            return "JerseyInstantiator [constructor=" + this.injectionPoint.getMember() + "]";
        }

        public boolean hasInterceptorSupport() {
            return false;
        }

        public boolean hasDecoratorSupport() {
            return false;
        }
    }
}

