/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.weld.internal.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glassfish.jersey.inject.weld.internal.inject.MatchableBinding;
import org.glassfish.jersey.internal.inject.AliasBinding;
import org.glassfish.jersey.internal.inject.Binding;
import org.glassfish.jersey.internal.inject.InstanceBinding;

public class InitializableInstanceBinding<T>
extends MatchableBinding<T, InitializableInstanceBinding<T>>
implements Cloneable {
    protected T service;
    private AtomicBoolean isInit = new AtomicBoolean(false);
    private Class<T> implementationType;

    protected InitializableInstanceBinding(T service) {
        this(service, null);
    }

    private InitializableInstanceBinding(T service, Type contractType) {
        this.service = service;
        Class<Object> clazz = this.implementationType = service == null ? null : service.getClass();
        if (contractType != null) {
            this.to(contractType);
        }
    }

    public T getService() {
        if (!this.isInit.get()) {
            String types = Arrays.toString(this.getContracts().toArray());
            throw new IllegalStateException("Not initialized " + this.service + "(" + types + ")");
        }
        return this.service;
    }

    public Class<T> getImplementationType() {
        return this.implementationType;
    }

    public void init(T service) {
        if (!this.isInit.getAndSet(true)) {
            this.service = service;
            this.implementationType = service.getClass();
        } else if (this.service != service) {
            throw new IllegalStateException("Multiple initialized for " + service.getClass());
        }
    }

    public boolean isInit() {
        return this.isInit.get();
    }

    @Override
    public MatchableBinding.Matching<InitializableInstanceBinding<T>> matches(Binding other) {
        return super.matches(other);
    }

    public InitializableInstanceBinding<T> clone() {
        throw new RuntimeException(new CloneNotSupportedException());
    }

    public static <T> InitializableInstanceBinding<T> from(InstanceBinding<T> instanceBinding) {
        return new InitializableWrappingInstanceBinding<T>(instanceBinding);
    }

    @Override
    protected MatchableBinding.MatchLevel bestMatchLevel() {
        return MatchableBinding.MatchLevel.IMPLEMENTATION;
    }

    private static class InitializableWrappingInstanceBinding<T>
    extends InitializableInstanceBinding<T> {
        private final InstanceBinding<T> wrapped;

        public InitializableWrappingInstanceBinding(InstanceBinding<T> binding) {
            super(binding.getService());
            this.wrapped = binding;
        }

        private InitializableWrappingInstanceBinding(InitializableWrappingInstanceBinding<T> binding) {
            super(binding.service);
            this.wrapped = binding.wrapped;
        }

        @Override
        public Class<T> getImplementationType() {
            return super.getImplementationType();
        }

        @Override
        public T getService() {
            return super.getService();
        }

        public Class<? extends Annotation> getScope() {
            return this.wrapped.getScope();
        }

        public Set<Type> getContracts() {
            return this.wrapped.getContracts();
        }

        public Integer getRank() {
            return this.wrapped.getRank();
        }

        public Set<AliasBinding> getAliases() {
            return this.wrapped.getAliases();
        }

        public Set<Annotation> getQualifiers() {
            return this.wrapped.getQualifiers();
        }

        public String getAnalyzer() {
            return this.wrapped.getAnalyzer();
        }

        public String getName() {
            return this.wrapped.getName();
        }

        public String toString() {
            return "InitializableWrappingInstanceBinding(" + this.wrapped.getService().getClass() + ")";
        }

        @Override
        public InitializableWrappingInstanceBinding clone() {
            return new InitializableWrappingInstanceBinding<T>(this);
        }
    }
}

