/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.weld.internal.managed;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InjectionTargetFactory;
import javax.enterprise.inject.spi.Unmanaged;
import javax.inject.Singleton;
import javax.ws.rs.RuntimeType;
import org.glassfish.jersey.inject.weld.internal.bean.JerseyBean;
import org.glassfish.jersey.inject.weld.internal.inject.InitializableInstanceBinding;
import org.glassfish.jersey.inject.weld.internal.inject.InitializableSupplierInstanceBinding;
import org.glassfish.jersey.inject.weld.internal.inject.MatchableBinding;
import org.glassfish.jersey.inject.weld.internal.managed.LocalizationMessages;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.Binding;
import org.glassfish.jersey.internal.inject.Bindings;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.glassfish.jersey.internal.inject.ForeignDescriptor;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.internal.inject.ServiceHolder;
import org.glassfish.jersey.internal.inject.ServiceHolderImpl;
import org.glassfish.jersey.internal.inject.SupplierInstanceBinding;

@Singleton
public class CdiInjectionManager
implements InjectionManager {
    private final BeanManager beanManager;
    private final Binder bindings;
    private boolean isCompleted = false;
    Set<Class<?>> managedBeans;

    public CdiInjectionManager(BeanManager beanManager, Binder bindings) {
        this.beanManager = beanManager;
        this.bindings = bindings;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void register(Binding binding) {
        Binding preBinding;
        if (this.isManagedClass(binding)) {
            return;
        }
        if (InstanceBinding.class.isInstance(binding)) {
            Binding preBinding2;
            Collection preBindings = this.bindings.getBindings();
            MatchableBinding.Matching matching = MatchableBinding.Matching.noneMatching();
            Iterator iterator = preBindings.iterator();
            while (!(!iterator.hasNext() || InitializableInstanceBinding.class.isInstance(preBinding2 = (Binding)iterator.next()) && (matching = matching.better(((InitializableInstanceBinding)preBinding2).matches((Binding)((InstanceBinding)binding)))).isBest())) {
            }
            if (matching.matches()) {
                ((InitializableInstanceBinding)matching.getBinding()).init(((InstanceBinding)binding).getService());
                return;
            }
            if (this.findClassBinding(binding.getImplementationType()) != null) return;
            throw new IllegalStateException("Not initialized " + ((InstanceBinding)binding).getService());
        }
        if (!SupplierInstanceBinding.class.isInstance(binding)) {
            if (!ClassBinding.class.isInstance(binding)) return;
            if (this.findClassBinding(binding.getImplementationType()) != null) return;
            throw new IllegalStateException("ClassBinding for " + binding.getImplementationType() + " not preregistered");
        }
        Collection preBindings = this.bindings.getBindings();
        MatchableBinding.Matching matching = MatchableBinding.Matching.noneMatching();
        Iterator iterator = preBindings.iterator();
        while (!(!iterator.hasNext() || InitializableSupplierInstanceBinding.class.isInstance(preBinding = (Binding)iterator.next()) && (matching = matching.better(((InitializableSupplierInstanceBinding)preBinding).matches((SupplierInstanceBinding)binding))).isBest())) {
        }
        if (!matching.matches()) throw new IllegalStateException("Not initialized " + ((SupplierInstanceBinding)binding).getSupplier());
        ((InitializableSupplierInstanceBinding)matching.getBinding()).init(((SupplierInstanceBinding)binding).getSupplier());
    }

    private <T> ClassBinding<T> findClassBinding(Class<T> implementationType) {
        Collection preBindings = this.bindings.getBindings();
        boolean found = false;
        for (Binding preBinding : preBindings) {
            if (!ClassBinding.class.isInstance(preBinding) || !((ClassBinding)preBinding).getImplementationType().equals(implementationType)) continue;
            return (ClassBinding)preBinding;
        }
        return null;
    }

    private boolean isManagedClass(Binding binding) {
        return this.managedBeans != null && binding.getImplementationType() != null && (this.managedBeans.contains(binding.getImplementationType()) || this.managedBeans.contains(binding.getImplementationType().getSuperclass()));
    }

    public void register(Iterable<Binding> bindings) {
        for (Binding binding : bindings) {
            this.register(binding);
        }
    }

    public void register(Binder binder) {
        for (Binding binding : Bindings.getBindings((InjectionManager)this, (Binder)binder)) {
            this.register(binding);
        }
    }

    public void register(Object provider) throws IllegalArgumentException {
        throw new IllegalArgumentException(LocalizationMessages.CDI_2_PROVIDER_NOT_REGISTRABLE(provider.getClass()));
    }

    public boolean isRegistrable(Class<?> clazz) {
        return false;
    }

    public <T> T create(Class<T> createMe) {
        Unmanaged.UnmanagedInstance unmanaged = new Unmanaged(createMe).newInstance();
        return (T)unmanaged.produce().get();
    }

    public <T> T createAndInitialize(Class<T> createMe) {
        Unmanaged.UnmanagedInstance unmanaged = new Unmanaged(createMe).newInstance();
        return (T)unmanaged.produce().inject().postConstruct().get();
    }

    public <T> List<ServiceHolder<T>> getAllServiceHolders(Class<T> contractOrImpl, Annotation ... qualifiers) {
        ArrayList<ServiceHolder<T>> result = new ArrayList<ServiceHolder<T>>();
        for (Bean bean : this.beanManager.getBeans(contractOrImpl, qualifiers)) {
            if (!this.isRuntimeTypeBean(bean)) continue;
            CreationalContext<T> ctx = this.createCreationalContext(bean);
            Object reference = this.beanManager.getReference(bean, contractOrImpl, ctx);
            int rank = 1;
            if (bean instanceof JerseyBean) {
                rank = ((JerseyBean)bean).getRank();
            }
            result.add((ServiceHolder<T>)new ServiceHolderImpl(reference, bean.getBeanClass(), bean.getTypes(), rank));
        }
        return result;
    }

    public <T> T getInstance(Class<T> contractOrImpl, Annotation ... qualifiers) {
        return this.getInstanceInternal(contractOrImpl, qualifiers);
    }

    public <T> T getInstance(Class<T> contractOrImpl) {
        return this.getInstanceInternal(contractOrImpl, new Annotation[0]);
    }

    public <T> T getInstance(Type contractOrImpl) {
        return this.getInstanceInternal(contractOrImpl, new Annotation[0]);
    }

    protected <T> T getInstanceInternal(Type contractOrImpl, Annotation ... qualifiers) {
        Set beans = this.beanManager.getBeans(contractOrImpl, qualifiers);
        if (beans.isEmpty()) {
            return null;
        }
        Iterator beansIterator = beans.iterator();
        Bean bean = (Bean)beansIterator.next();
        while (beansIterator.hasNext() && !JerseyBean.class.isInstance(bean) && !this.isRuntimeTypeBean(bean)) {
            bean = (Bean)beansIterator.next();
        }
        CreationalContext<T> ctx = this.createCreationalContext(bean);
        return (T)this.beanManager.getReference(bean, contractOrImpl, ctx);
    }

    public Object getInstance(ForeignDescriptor foreignDescriptor) {
        Bean bean = (Bean)foreignDescriptor.get();
        CreationalContext ctx = this.createCreationalContext(bean);
        return bean.create(ctx);
    }

    public ForeignDescriptor createForeignDescriptor(Binding binding) {
        Class<?> clazz;
        if (ClassBinding.class.isAssignableFrom(binding.getClass())) {
            clazz = ((ClassBinding)binding).getService();
        } else if (InstanceBinding.class.isAssignableFrom(binding.getClass())) {
            clazz = ((InstanceBinding)binding).getService().getClass();
        } else {
            throw new RuntimeException(org.glassfish.jersey.internal.LocalizationMessages.UNKNOWN_DESCRIPTOR_TYPE((Object)binding.getClass().getSimpleName()));
        }
        Set beans = this.beanManager.getBeans(clazz, new Annotation[0]);
        if (beans.isEmpty()) {
            return null;
        }
        Bean bean = (Bean)beans.iterator().next();
        CreationalContext ctx = this.createCreationalContext(bean);
        return ForeignDescriptor.wrap((Object)bean, instance -> bean.destroy(instance, ctx));
    }

    public <T> List<T> getAllInstances(Type contractOrImpl) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Bean bean : this.beanManager.getBeans(contractOrImpl, new Annotation[0])) {
            CreationalContext<T> ctx = this.createCreationalContext(bean);
            Object reference = this.beanManager.getReference(bean, contractOrImpl, ctx);
            result.add(reference);
        }
        return result;
    }

    public void inject(Object instance) {
        CreationalContext creationalContext = this.createCreationalContext(null);
        AnnotatedType annotatedType = this.beanManager.createAnnotatedType(instance.getClass());
        InjectionTargetFactory injectionTargetFactory = this.beanManager.getInjectionTargetFactory(annotatedType);
        InjectionTarget injectionTarget = injectionTargetFactory.createInjectionTarget(null);
        injectionTarget.inject(instance, creationalContext);
    }

    public void preDestroy(Object preDestroyMe) {
    }

    public void completeRegistration() throws IllegalStateException {
        if (!this.isCompleted) {
            this.register(Bindings.service((Object)this).to(InjectionManager.class));
            this.isCompleted = false;
        }
    }

    public void shutdown() {
    }

    public boolean isShutdown() {
        return false;
    }

    protected Binder getBindings() {
        return this.bindings;
    }

    protected BeanManager getBeanManager() {
        return this.beanManager;
    }

    protected <T> CreationalContext<T> createCreationalContext(Bean<T> bean) {
        return this.beanManager.createCreationalContext(bean);
    }

    protected boolean isRuntimeTypeBean(Bean<?> bean) {
        return !JerseyBean.class.isInstance(bean) || ((JerseyBean)bean).getRutimeType() == RuntimeType.SERVER;
    }

    public void inject(Object injectMe, String classAnalyzer) {
        throw new UnsupportedOperationException();
    }

    public <T> T getInstance(Class<T> contractOrImpl, String classAnalyzer) {
        throw new UnsupportedOperationException();
    }
}

