/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.weld.internal.injector;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import org.glassfish.jersey.inject.weld.internal.injector.Collector;
import org.glassfish.jersey.inject.weld.internal.injector.InjectionUtils;
import org.glassfish.jersey.inject.weld.internal.injector.JerseyProxyResolver;
import org.glassfish.jersey.internal.inject.InjectionResolver;

class JerseyInstanceInjector<T> {
    private final Bean<T> bean;
    private final Map<Field, InjectionResolver> cachedFields;
    private final JerseyProxyResolver proxyResolver = new JerseyProxyResolver();

    JerseyInstanceInjector(Bean<T> bean, Collection<InjectionResolver> resolvers) {
        this.bean = bean;
        this.cachedFields = this.analyzeFields(bean.getBeanClass(), resolvers);
    }

    void inject(T injectMe) {
        InjectionUtils.justInject(injectMe, this.bean, this.cachedFields, this.proxyResolver);
    }

    private Map<Field, InjectionResolver> analyzeFields(Class<?> clazz, Collection<InjectionResolver> resolvers) {
        Map<Class<?>, InjectionResolver> injectAnnotations = InjectionUtils.mapAnnotationToResolver(resolvers);
        Collector collector = new Collector();
        Set<Field> fields = InjectionUtils.getFields(clazz, injectAnnotations.keySet(), collector);
        collector.throwIfErrors();
        return InjectionUtils.mapElementToResolver(fields, injectAnnotations);
    }
}

