/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.weld.internal.bean;

import java.lang.annotation.Annotation;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.ws.rs.RuntimeType;
import org.glassfish.jersey.inject.weld.internal.bean.JerseyBean;
import org.glassfish.jersey.inject.weld.internal.inject.InitializableInstanceBinding;
import org.glassfish.jersey.inject.weld.internal.injector.JerseyClientCreationalContext;

public class InitializableInstanceBean<T>
extends JerseyBean<T> {
    private InjectionTarget<T> injectionTarget;

    InitializableInstanceBean(RuntimeType runtimeType, InitializableInstanceBinding<T> binding) {
        super(runtimeType, binding);
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return this.getBinding().getScope() == null ? Dependent.class : InitializableInstanceBean.transformScope(this.getBinding().getScope());
    }

    public T create(CreationalContext<T> context) {
        InitializableInstanceBinding realBinding = (InitializableInstanceBinding)this.getBinding();
        if (JerseyClientCreationalContext.class.isInstance(context)) {
            realBinding = ((JerseyClientCreationalContext)context).getInjectionManager().getInjectionManagerBinding(realBinding);
        }
        Object service = realBinding.getService();
        this.injectionTarget.inject(service, context);
        return service;
    }

    @Override
    public Class<?> getBeanClass() {
        InitializableInstanceBinding binding = (InitializableInstanceBinding)this.getBinding();
        return binding.isInit() ? binding.getImplementationType() : Object.class;
    }

    void setInjectionTarget(InjectionTarget<T> injectionTarget) {
        this.injectionTarget = injectionTarget;
    }

    public String toString() {
        return "InitializableInstanceBean{" + this.getBeanClass() + "}";
    }
}

