/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.weld.internal.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Singleton;
import javax.ws.rs.RuntimeType;
import org.glassfish.jersey.JerseyPriorities;
import org.glassfish.jersey.internal.inject.Binding;
import org.glassfish.jersey.internal.inject.PerLookup;
import org.glassfish.jersey.internal.inject.PerThread;
import org.jboss.weld.environment.se.contexts.ThreadScoped;

public abstract class JerseyBean<T>
implements Bean<T>,
PassivationCapable {
    static final Set<Annotation> DEFAULT_QUALIFIERS = new HashSet<Annotation>();
    private final Binding<T, ?> binding;
    private final RuntimeType runtimeType;

    public Binding<T, ?> getBinding() {
        return this.binding;
    }

    JerseyBean(RuntimeType runtimeType, Binding<T, ?> binding) {
        this.binding = binding;
        this.runtimeType = runtimeType == null ? RuntimeType.SERVER : runtimeType;
    }

    protected static Class<? extends Annotation> transformScope(Class<? extends Annotation> scope) {
        if (scope == PerLookup.class) {
            return Dependent.class;
        }
        if (scope == PerThread.class) {
            return ThreadScoped.class;
        }
        if (scope == org.glassfish.jersey.process.internal.RequestScoped.class) {
            return RequestScoped.class;
        }
        return scope;
    }

    public Set<Type> getTypes() {
        HashSet<Type> contracts = new HashSet<Type>();
        contracts.addAll(this.binding.getContracts());
        if (!this.binding.getAliases().isEmpty()) {
            this.binding.getAliases().forEach(alias -> contracts.add(alias.getContract()));
        }
        contracts.add((Type)((Object)Object.class));
        return contracts;
    }

    public Set<Annotation> getQualifiers() {
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        qualifiers.addAll(DEFAULT_QUALIFIERS);
        if (this.binding.getQualifiers() != null) {
            qualifiers.addAll(this.binding.getQualifiers());
        }
        if (!this.binding.getAliases().isEmpty()) {
            this.binding.getAliases().forEach(alias -> qualifiers.addAll(alias.getQualifiers()));
        }
        return qualifiers;
    }

    public String getName() {
        return this.binding.getName();
    }

    public Class<? extends Annotation> getScope() {
        return Singleton.class;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    public boolean isNullable() {
        return false;
    }

    public void destroy(T instance, CreationalContext<T> creationalContext) {
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public int getRank() {
        if (this.binding.getRank() != null) {
            return this.binding.getRank();
        }
        int defaultValue = 1;
        Class type = this.binding.getImplementationType();
        if (type != null) {
            return JerseyPriorities.getPriorityValue((Class)type, (int)defaultValue);
        }
        return defaultValue;
    }

    public Class<?> getBeanClass() {
        return Object.class;
    }

    public String getId() {
        return (this.getBeanClass().equals(Object.class) ? this.getContractsAsString() : this.getBeanClass().getTypeName()) + "#jersey" + this.runtimeType;
    }

    public RuntimeType getRutimeType() {
        return this.runtimeType;
    }

    public String getContractsAsString() {
        return Arrays.toString(this.binding.getContracts().toArray());
    }

    static {
        DEFAULT_QUALIFIERS.add((Annotation)new AnnotationLiteral<Default>(){});
        DEFAULT_QUALIFIERS.add((Annotation)new AnnotationLiteral<Any>(){});
    }
}

