/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.weld.internal.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.ws.rs.RuntimeType;
import org.glassfish.jersey.inject.weld.internal.bean.JerseyBean;
import org.glassfish.jersey.inject.weld.internal.type.ParameterizedTypeImpl;
import org.glassfish.jersey.internal.inject.DisposableSupplier;
import org.glassfish.jersey.internal.inject.SupplierClassBinding;

class SupplierClassBean<T>
extends JerseyBean<Supplier<T>> {
    private final Set<Type> contracts = new HashSet<Type>();
    private final Class<? extends Supplier<T>> supplierClass;
    private final Class<? extends Annotation> supplierScope;
    private InjectionTarget<Supplier<T>> injectionTarget;

    SupplierClassBean(RuntimeType runtimeType, SupplierClassBinding<T> binding) {
        super(runtimeType, binding);
        this.supplierClass = binding.getSupplierClass();
        this.supplierScope = binding.getSupplierScope();
        for (Type contract : binding.getContracts()) {
            this.contracts.add(new ParameterizedTypeImpl((Type)((Object)Supplier.class), contract));
            if (!DisposableSupplier.class.isAssignableFrom(this.supplierClass)) continue;
            this.contracts.add(new ParameterizedTypeImpl((Type)((Object)DisposableSupplier.class), contract));
        }
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return this.supplierScope == null ? Dependent.class : SupplierClassBean.transformScope(this.supplierScope);
    }

    @Override
    public Set<Type> getTypes() {
        return this.contracts;
    }

    public Supplier<T> create(CreationalContext<Supplier<T>> context) {
        Supplier instance = (Supplier)this.injectionTarget.produce(context);
        this.injectionTarget.inject((Object)instance, context);
        this.injectionTarget.postConstruct((Object)instance);
        return instance;
    }

    @Override
    public void destroy(Supplier<T> instance, CreationalContext<Supplier<T>> context) {
        this.injectionTarget.preDestroy(instance);
        this.injectionTarget.dispose(instance);
        context.release();
    }

    @Override
    public Class<?> getBeanClass() {
        return this.supplierClass;
    }

    void setInjectionTarget(InjectionTarget<Supplier<T>> injectionTarget) {
        this.injectionTarget = injectionTarget;
    }

    public InjectionTarget<Supplier<T>> getInjectionTarget() {
        return this.injectionTarget;
    }
}

