/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.weld.internal.bean;

import java.lang.reflect.Method;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.PassivationCapable;
import org.jboss.weld.bean.StringBeanIdentifier;
import org.jboss.weld.bean.proxy.ContextBeanInstance;
import org.jboss.weld.serialization.spi.BeanIdentifier;

class ThreadScopeBeanInstance<T>
extends ContextBeanInstance<T> {
    private final WeakHashMap<Thread, Object> instances = new WeakHashMap();
    private final Supplier<T> supplier;

    ThreadScopeBeanInstance(Supplier<T> supplier, Bean<T> bean, String contextId) {
        super(bean, (BeanIdentifier)new StringBeanIdentifier(((PassivationCapable)bean).getId()), contextId);
        this.supplier = supplier;
    }

    public Object invoke(Object obj, Method method, Object ... arguments) throws Throwable {
        Object instance = this.instances.computeIfAbsent(Thread.currentThread(), thread -> this.supplier.get());
        return super.invoke(instance, method, arguments);
    }

    public void dispose() {
        this.instances.clear();
    }
}

