/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.weld.managed;

import jakarta.annotation.Priority;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.ws.rs.RuntimeType;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.inject.weld.internal.injector.JerseyClientCreationalContext;
import org.glassfish.jersey.inject.weld.internal.managed.CdiInjectionManagerFactoryBase;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.InjectionManagerFactory;
import org.glassfish.jersey.server.ApplicationHandler;

@Priority(value=20)
public class CdiInjectionManagerFactory
extends CdiInjectionManagerFactoryBase
implements InjectionManagerFactory {
    public InjectionManager create(Object parent) {
        return this.create(parent, CdiInjectionManagerFactory.getRuntimeType());
    }

    public InjectionManager create(Object parent, RuntimeType runtimeType) {
        return CdiInjectionManagerFactory.getInjectionManager(runtimeType);
    }

    public static InjectionManager getInjectionManager(CreationalContext<?> creationalContext) {
        if (JerseyClientCreationalContext.class.isInstance(creationalContext)) {
            return ((JerseyClientCreationalContext)creationalContext).getInjectionManager();
        }
        return CdiInjectionManagerFactory.getInjectionManager(RuntimeType.SERVER);
    }

    private static RuntimeType getRuntimeType() {
        RuntimeException e = new RuntimeException();
        for (StackTraceElement element : e.getStackTrace()) {
            if (element.getClassName().equals(ClientConfig.class.getName())) {
                return RuntimeType.CLIENT;
            }
            if (!element.getClassName().equals(ApplicationHandler.class.getName())) continue;
            return RuntimeType.SERVER;
        }
        return RuntimeType.SERVER;
    }
}

