/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.weld.internal.injector;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.GenericType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.function.Supplier;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.Binding;
import org.glassfish.jersey.internal.inject.Bindings;
import org.glassfish.jersey.internal.inject.ContextInjectionResolver;
import org.glassfish.jersey.internal.inject.Injectee;
import org.glassfish.jersey.internal.inject.InjecteeImpl;
import org.glassfish.jersey.internal.inject.InjectionResolver;
import org.glassfish.jersey.internal.inject.InjectionResolverBinding;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.collection.Cache;

public class ContextInjectionResolverImpl
implements InjectionResolver<Context>,
ContextInjectionResolver {
    private Supplier<BeanManager> beanManager;
    private final Cache<Type, Bean<?>> descriptorCache = new Cache(key -> {
        Set beans = this.beanManager.get().getBeans(key, new Annotation[0]);
        if (beans.isEmpty()) {
            return null;
        }
        return (Bean)beans.iterator().next();
    });

    ContextInjectionResolverImpl(Supplier<BeanManager> beanManager) {
        this.beanManager = beanManager;
    }

    public Object resolve(Injectee injectee) {
        Bean bean;
        Injectee newInjectee = injectee;
        if (injectee.isFactory()) {
            newInjectee = this.getFactoryInjectee(injectee, ReflectionHelper.getTypeArgument((Type)injectee.getRequiredType(), (int)0));
        }
        if ((bean = (Bean)this.descriptorCache.apply((Object)newInjectee.getRequiredType())) != null) {
            CreationalContext ctx = this.beanManager.get().createCreationalContext((Contextual)bean);
            Object result = bean.create(ctx);
            if (injectee.isFactory()) {
                return () -> result;
            }
            return result;
        }
        return null;
    }

    public boolean isConstructorParameterIndicator() {
        return true;
    }

    public boolean isMethodParameterIndicator() {
        return false;
    }

    public Class<Context> getAnnotation() {
        return Context.class;
    }

    private Injectee getFactoryInjectee(Injectee injectee, Type requiredType) {
        return new RequiredTypeOverridingInjectee(injectee, requiredType);
    }

    private static class RequiredTypeOverridingInjectee
    extends InjecteeImpl {
        private RequiredTypeOverridingInjectee(Injectee injectee, Type requiredType) {
            this.setFactory(injectee.isFactory());
            this.setInjecteeClass(injectee.getInjecteeClass());
            this.setInjecteeDescriptor(injectee.getInjecteeDescriptor());
            this.setOptional(injectee.isOptional());
            this.setParent(injectee.getParent());
            this.setPosition(injectee.getPosition());
            this.setRequiredQualifiers(injectee.getRequiredQualifiers());
            this.setRequiredType(requiredType);
        }
    }

    public static final class Binder
    extends AbstractBinder {
        private Supplier<BeanManager> beanManager;

        public Binder(Supplier<BeanManager> beanManager) {
            this.beanManager = beanManager;
        }

        protected void configure() {
            ContextInjectionResolverImpl resolver = new ContextInjectionResolverImpl(this.beanManager);
            ((InjectionResolverBinding)this.bind(resolver).to((GenericType)new GenericType<InjectionResolver<Context>>(){})).to(ContextInjectionResolver.class);
            this.bind((Binding)Bindings.service((Object)resolver)).to((GenericType)new GenericType<InjectionResolver<Context>>(){}).to(ContextInjectionResolver.class);
        }
    }
}

