/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.weld.internal.injector;

import jakarta.enterprise.inject.spi.Bean;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.glassfish.jersey.inject.weld.internal.injector.Collector;
import org.glassfish.jersey.inject.weld.internal.injector.JerseyProxyResolver;
import org.glassfish.jersey.inject.weld.internal.injector.MultiException;
import org.glassfish.jersey.inject.weld.internal.injector.NamedImpl;
import org.glassfish.jersey.inject.weld.internal.injector.ReflectionUtils;
import org.glassfish.jersey.internal.inject.Injectee;
import org.glassfish.jersey.internal.inject.InjecteeImpl;
import org.glassfish.jersey.internal.inject.InjectionResolver;
import org.glassfish.jersey.internal.util.Pretty;
import org.glassfish.jersey.internal.util.collection.ImmutableCollectors;

public final class InjectionUtils {
    private InjectionUtils() {
    }

    static <T> void justInject(T injectMe, Bean<T> bean, Map<Field, InjectionResolver> resolvers, JerseyProxyResolver proxyResolver) {
        if (injectMe == null) {
            throw new IllegalArgumentException();
        }
        for (Map.Entry<Field, InjectionResolver> entry : resolvers.entrySet()) {
            Field field = entry.getKey();
            InjectionResolver resolver = entry.getValue();
            Injectee injectee = InjectionUtils.getFieldInjectee(bean, field);
            Object resolvedValue = injectee.isProvider() ? () -> resolver.resolve(injectee) : (proxyResolver.isProxiable(injectee) ? proxyResolver.proxy(injectee, resolver) : resolver.resolve(injectee));
            try {
                ReflectionUtils.setField(field, injectMe, resolvedValue);
            }
            catch (MultiException me) {
                throw me;
            }
            catch (Throwable th) {
                throw new MultiException(th);
            }
        }
    }

    private static Injectee getFieldInjectee(Bean<?> bean, Field field) {
        Set annotations = (Set)Arrays.stream(field.getAnnotations()).collect(ImmutableCollectors.toImmutableSet());
        Type adjustedType = ReflectionUtils.resolveField(bean.getBeanClass(), field);
        InjecteeImpl injectee = new InjecteeImpl();
        injectee.setParentClassScope(bean.getScope());
        if (InjectionUtils.isProvider(adjustedType)) {
            ParameterizedType paramType = (ParameterizedType)adjustedType;
            injectee.setRequiredType(paramType.getActualTypeArguments()[0]);
            injectee.setProvider(true);
        } else {
            injectee.setRequiredType(adjustedType);
        }
        injectee.setParent((AnnotatedElement)field);
        injectee.setRequiredQualifiers(InjectionUtils.getFieldAdjustedQualifierAnnotations(field, annotations));
        return injectee;
    }

    public static boolean isProvider(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            return Provider.class.isAssignableFrom((Class)paramType.getRawType());
        }
        return false;
    }

    private static Set<Annotation> getFieldAdjustedQualifierAnnotations(Field field, Set<Annotation> qualifiers) {
        Named n = field.getAnnotation(Named.class);
        if (n == null || !"".equals(n.value())) {
            return qualifiers;
        }
        HashSet<Annotation> retVal = new HashSet<Annotation>();
        for (Annotation qualifier : qualifiers) {
            if (qualifier.annotationType().equals(Named.class)) {
                retVal.add((Annotation)((Object)new NamedImpl(field.getName())));
                continue;
            }
            retVal.add(qualifier);
        }
        return retVal;
    }

    static Set<Field> getFields(Class<?> clazz, Set<? extends Class<?>> injectAnnotations, Collector errors) {
        Set<Field> retVal;
        try {
            retVal = InjectionUtils.getFieldsInternal(clazz, injectAnnotations, errors);
        }
        catch (MultiException me) {
            errors.addMultiException(me);
            return Collections.emptySet();
        }
        catch (Throwable th) {
            errors.addThrowable(th);
            return Collections.emptySet();
        }
        return retVal;
    }

    private static Set<Field> getFieldsInternal(Class<?> clazz, Set<? extends Class<?>> injectAnnotations, Collector errors) {
        LinkedHashSet<Field> retVal = new LinkedHashSet<Field>();
        for (Field field : ReflectionUtils.getAllFields(clazz)) {
            if (!InjectionUtils.hasInjectAnnotation(field, injectAnnotations)) continue;
            if (!InjectionUtils.isProperField(field)) {
                errors.addThrowable(new IllegalArgumentException("The field " + Pretty.field((Field)field) + " may not be static, final or have an Annotation type"));
                continue;
            }
            retVal.add(field);
        }
        return retVal;
    }

    private static boolean hasInjectAnnotation(AnnotatedElement annotated, Set<? extends Class<?>> injectAnnotations) {
        for (Annotation annotation : annotated.getAnnotations()) {
            if (!injectAnnotations.contains(annotation.annotationType())) continue;
            return true;
        }
        return false;
    }

    private static boolean isProperField(Field field) {
        if (InjectionUtils.isStatic(field) || InjectionUtils.isFinal(field)) {
            return false;
        }
        Class<?> type = field.getType();
        return !type.isAnnotation();
    }

    private static boolean isStatic(Member member) {
        int modifiers = member.getModifiers();
        return (modifiers & 8) != 0;
    }

    private static boolean isFinal(Member member) {
        int modifiers = member.getModifiers();
        return (modifiers & 0x10) != 0;
    }

    public static Collection<Class<? extends Annotation>> getInjectAnnotations(Collection<InjectionResolver> resolvers) {
        ArrayList<Class<? extends Annotation>> annotations = new ArrayList<Class<? extends Annotation>>();
        for (InjectionResolver resolver : resolvers) {
            annotations.add(resolver.getAnnotation());
        }
        return annotations;
    }

    static <A extends AnnotatedElement> Map<A, InjectionResolver> mapElementToResolver(Set<A> annotatedElements, Map<? extends Class<?>, InjectionResolver> resolvers) {
        HashMap<AnnotatedElement, InjectionResolver> mappedElements = new HashMap<AnnotatedElement, InjectionResolver>();
        for (AnnotatedElement element : annotatedElements) {
            mappedElements.put(element, InjectionUtils.findResolver(resolvers, element));
        }
        return mappedElements;
    }

    static InjectionResolver findResolver(Map<? extends Class<?>, InjectionResolver> resolvers, AnnotatedElement element) {
        for (Annotation annotation : element.getAnnotations()) {
            InjectionResolver injectionResolver = resolvers.get(annotation.annotationType());
            if (injectionResolver == null) continue;
            return injectionResolver;
        }
        return null;
    }

    static Map<? extends Class<?>, InjectionResolver> mapAnnotationToResolver(Collection<InjectionResolver> resolvers) {
        return resolvers.stream().collect(Collectors.toMap(InjectionResolver::getAnnotation, Function.identity()));
    }
}

