/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.weld.internal.bean;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.ws.rs.RuntimeType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.glassfish.jersey.inject.weld.internal.bean.JerseyBean;
import org.glassfish.jersey.inject.weld.internal.inject.InitializableSupplierInstanceBinding;
import org.glassfish.jersey.inject.weld.internal.injector.JerseyClientCreationalContext;
import org.glassfish.jersey.inject.weld.internal.type.ParameterizedTypeImpl;
import org.glassfish.jersey.internal.inject.DisposableSupplier;

class InitializableSupplierInstanceBean<T>
extends JerseyBean<Supplier<T>> {
    private final Set<Type> contracts = new HashSet<Type>();
    private final Supplier<T> supplier;

    InitializableSupplierInstanceBean(RuntimeType runtimeType, InitializableSupplierInstanceBinding<T> binding) {
        super(runtimeType, binding);
        this.supplier = binding.getSupplier();
        for (Type contract : binding.getContracts()) {
            this.contracts.add(new ParameterizedTypeImpl((Type)((Object)Supplier.class), contract));
            if (!DisposableSupplier.class.isAssignableFrom(binding.getSupplier().getClass())) continue;
            this.contracts.add(new ParameterizedTypeImpl((Type)((Object)DisposableSupplier.class), contract));
        }
    }

    @Override
    public Set<Type> getTypes() {
        return this.contracts;
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return DEFAULT_QUALIFIERS;
    }

    public Supplier<T> create(CreationalContext<Supplier<T>> context) {
        if (JerseyClientCreationalContext.class.isInstance(context)) {
            InitializableSupplierInstanceBinding binding = (InitializableSupplierInstanceBinding)this.getBinding();
            JerseyClientCreationalContext jerseyContext = (JerseyClientCreationalContext)context;
            return jerseyContext.getInjectionManager().getInjectionManagerBinding(binding).getSupplier();
        }
        return this.supplier;
    }

    @Override
    public Class<?> getBeanClass() {
        InitializableSupplierInstanceBinding binding = (InitializableSupplierInstanceBinding)this.getBinding();
        return binding.isInit() ? binding.getOriginalSupplier().getClass() : Object.class;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return this.getBinding().getScope() == null ? Dependent.class : InitializableSupplierInstanceBean.transformScope(this.getBinding().getScope());
    }
}

