/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.weld.internal.scope;

import jakarta.inject.Inject;
import java.util.concurrent.Callable;
import org.glassfish.jersey.inject.weld.internal.scope.CdiRequestContext;
import org.glassfish.jersey.process.internal.RequestContext;
import org.glassfish.jersey.process.internal.RequestScope;
import org.jboss.weld.context.bound.BoundRequestContext;

public class CdiRequestScope
extends RequestScope {
    @Inject
    private BoundRequestContext requestContextController;

    public RequestContext createContext() {
        return new CdiRequestContext();
    }

    protected void activate(RequestContext context, RequestContext oldContext) {
        super.activate(context, oldContext);
        if (oldContext != null) {
            CdiRequestContext oldRequestContext = (CdiRequestContext)oldContext;
            this.requestContextController.deactivate();
            this.requestContextController.dissociate(oldRequestContext.getStore());
        }
        CdiRequestContext cdiRequestContext = (CdiRequestContext)context;
        this.requestContextController.associate(cdiRequestContext.getStore());
        this.requestContextController.activate();
    }

    protected void resume(RequestContext context) {
        super.resume(context);
        if (context != null) {
            CdiRequestContext cdiRequestContext = (CdiRequestContext)context;
            this.requestContextController.associate(cdiRequestContext.getStore());
            this.requestContextController.activate();
        }
    }

    protected void release(RequestContext context) {
        super.release(context);
        CdiRequestContext cdiRequestContext = (CdiRequestContext)context;
        this.requestContextController.invalidate();
        this.requestContextController.deactivate();
        this.requestContextController.dissociate(cdiRequestContext.getStore());
    }

    protected void suspend(RequestContext context) {
        if (context != null) {
            CdiRequestContext cdiRequestContext = (CdiRequestContext)context;
            this.requestContextController.deactivate();
            this.requestContextController.dissociate(cdiRequestContext.getStore());
        }
    }

    public <T> T runInScope(Callable<T> task) throws Exception {
        return (T)super.runInScope(task);
    }
}

