/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.weld.internal.inject;

import java.lang.reflect.Type;
import java.util.Set;
import org.glassfish.jersey.internal.inject.Binding;

public abstract class MatchableBinding<T, D extends MatchableBinding>
extends Binding<T, D> {
    protected abstract MatchLevel bestMatchLevel();

    protected Matching<D> matches(Binding<?, ?> other) {
        Matching<D> matching = this.matchesContracts(other);
        if (matching.matchLevel == MatchLevel.FULL_CONTRACT && this.getImplementationType().equals(other.getImplementationType())) {
            matching.matchLevel = MatchLevel.IMPLEMENTATION;
        }
        return matching;
    }

    public Matching<D> matchesContracts(Binding<?, ?> other) {
        boolean atLeastOneMatch = false;
        boolean allMatch = true;
        Set firstContracts = this.getContracts();
        Set secondContracts = other.getContracts();
        Set biggerContracts = firstContracts.size() < secondContracts.size() ? secondContracts : firstContracts;
        Set smallerContracts = firstContracts.size() < secondContracts.size() ? firstContracts : secondContracts;
        for (Type thisType : biggerContracts) {
            boolean aMatch = false;
            for (Type otherType : smallerContracts) {
                if (!thisType.equals(otherType)) continue;
                aMatch = true;
                atLeastOneMatch = true;
                break;
            }
            if (aMatch) continue;
            allMatch = false;
        }
        MatchLevel matchLevel = atLeastOneMatch ? (allMatch ? MatchLevel.FULL_CONTRACT : MatchLevel.PARTIAL_CONTRACT) : MatchLevel.NONE;
        Matching<MatchableBinding> matching = new Matching<MatchableBinding>(this, matchLevel);
        return matching;
    }

    protected static enum MatchLevel {
        NONE(0),
        PARTIAL_CONTRACT(1),
        FULL_CONTRACT(2),
        IMPLEMENTATION(3),
        SUPPLIER(4);

        private final int level;

        private MatchLevel(int level) {
            this.level = level;
        }
    }

    public static class Matching<D extends MatchableBinding>
    implements Comparable<Matching> {
        private D binding;
        protected MatchLevel matchLevel;

        public static <D extends MatchableBinding> Matching<D> noneMatching() {
            return new Matching<Object>(null, MatchLevel.NONE);
        }

        protected Matching(D binding, MatchLevel matchLevel) {
            this.binding = binding;
            this.matchLevel = matchLevel;
        }

        @Override
        public int compareTo(Matching other) {
            return other.matchLevel.level - this.matchLevel.level;
        }

        public Matching better(Matching other) {
            return this.compareTo(other) <= 0 ? this : other;
        }

        public boolean isBest() {
            return this.matches() && this.matchLevel == ((MatchableBinding)((Object)this.binding)).bestMatchLevel();
        }

        public boolean matches() {
            return this.matchLevel.level > MatchLevel.NONE.level;
        }

        public D getBinding() {
            return this.binding;
        }
    }
}

