/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.weld.internal.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.glassfish.jersey.inject.weld.internal.inject.MatchableBinding;
import org.glassfish.jersey.internal.inject.AliasBinding;
import org.glassfish.jersey.internal.inject.Binding;
import org.glassfish.jersey.internal.inject.DisposableSupplier;
import org.glassfish.jersey.internal.inject.SupplierInstanceBinding;

public class InitializableSupplierInstanceBinding<T>
extends MatchableBinding<Supplier<T>, InitializableSupplierInstanceBinding<T>>
implements Cloneable {
    private final InitializableSupplier<T> supplier;

    public InitializableSupplierInstanceBinding(Supplier<T> supplier) {
        InitializableSupplier initializableSupplier = this.supplier = DisposableSupplier.class.isInstance(supplier) ? new InitializableDisposableSupplier((DisposableSupplier)supplier) : new InitializableSupplier<T>(supplier);
        if ("EmptyReferenceFactory".equals(supplier.getClass().getSimpleName())) {
            this.supplier.init(supplier);
            this.supplier.isReferencingFactory = true;
        }
        if ("InitializedReferenceFactory".equals(supplier.getClass().getSimpleName())) {
            this.supplier.init(supplier);
            this.supplier.isReferencingFactory = true;
        }
        T t = supplier.get();
    }

    public void init(Supplier<T> supplier) {
        this.supplier.init(supplier);
    }

    public boolean isInit() {
        return this.supplier.init.get();
    }

    public Supplier<T> getSupplier() {
        return this.supplier;
    }

    public Supplier<T> getOriginalSupplier() {
        if (this.supplier.originalSupplier == null) {
            throw new IllegalStateException("Supplier must not be null");
        }
        return this.supplier.originalSupplier;
    }

    public static <T> InitializableSupplierInstanceBinding<T> from(SupplierInstanceBinding<T> binding) {
        return new InitializableSupplierWrappingInstanceBinding(binding);
    }

    public InitializableSupplierInstanceBinding clone() {
        throw new RuntimeException(new CloneNotSupportedException());
    }

    public MatchableBinding.Matching matches(SupplierInstanceBinding<T> other) {
        return this.matches(this.getOriginalSupplier().getClass(), other.getSupplier().getClass(), (Binding)other);
    }

    public MatchableBinding.Matching matches(InitializableSupplierInstanceBinding<T> other) {
        return this.matches(this.getOriginalSupplier().getClass(), other.getSupplier().getClass(), other);
    }

    private MatchableBinding.Matching<InitializableSupplierInstanceBinding<T>> matches(Class<?> originalSupplierClass, Class<?> otherSupplierClass, Binding other) {
        boolean matchesService = originalSupplierClass.equals(otherSupplierClass);
        MatchableBinding.Matching<InitializableSupplierInstanceBinding<T>> matching = this.matchesContracts(other);
        if (matching.matchLevel == MatchableBinding.MatchLevel.FULL_CONTRACT && matchesService) {
            matching.matchLevel = MatchableBinding.MatchLevel.SUPPLIER;
        }
        return matching;
    }

    @Override
    protected MatchableBinding.MatchLevel bestMatchLevel() {
        return MatchableBinding.MatchLevel.SUPPLIER;
    }

    private static class InitializableSupplierWrappingInstanceBinding<T>
    extends InitializableSupplierInstanceBinding<T> {
        private final SupplierInstanceBinding wrapped;

        public InitializableSupplierWrappingInstanceBinding(SupplierInstanceBinding binding) {
            super(binding.getSupplier());
            this.wrapped = binding;
        }

        private InitializableSupplierWrappingInstanceBinding(InitializableSupplierWrappingInstanceBinding binding) {
            super(binding.getOriginalSupplier());
            this.wrapped = binding.wrapped;
        }

        public Class getImplementationType() {
            return super.getImplementationType();
        }

        @Override
        public Supplier getSupplier() {
            return super.getSupplier();
        }

        public Class<? extends Annotation> getScope() {
            return this.wrapped.getScope();
        }

        public Set<Type> getContracts() {
            return this.wrapped.getContracts();
        }

        public Integer getRank() {
            return this.wrapped.getRank();
        }

        public Set<AliasBinding> getAliases() {
            return this.wrapped.getAliases();
        }

        public Set<Annotation> getQualifiers() {
            return this.wrapped.getQualifiers();
        }

        public String getAnalyzer() {
            return this.wrapped.getAnalyzer();
        }

        public String getName() {
            return this.wrapped.getName();
        }

        @Override
        public InitializableSupplierWrappingInstanceBinding clone() {
            return new InitializableSupplierWrappingInstanceBinding<T>(this);
        }

        public String toString() {
            return "InitializableSupplierWrappingInstanceBinding(" + this.wrapped.getSupplier() + ")";
        }
    }

    private static class InitializableSupplier<T>
    implements Supplier<T> {
        private AtomicBoolean init = new AtomicBoolean(false);
        protected Supplier<T> supplier;
        protected final Supplier<T> originalSupplier;
        private boolean isReferencingFactory = false;

        private InitializableSupplier(Supplier<T> originalSupplier) {
            this.originalSupplier = originalSupplier;
        }

        private void init(Supplier<T> supply) {
            if (!this.init.getAndSet(true)) {
                this.supplier = supply;
            } else if (!this.isReferencingFactory && this.supplier != supply) {
                throw new IllegalStateException("Multiple initialized for " + this.originalSupplier.getClass());
            }
        }

        @Override
        public T get() {
            if (!this.init.get()) {
                throw new IllegalStateException("Not initialized" + this.originalSupplier.getClass());
            }
            return this.supplier.get();
        }

        public boolean isInit() {
            return this.init.get();
        }
    }

    private static class InitializableDisposableSupplier<T>
    extends InitializableSupplier<T>
    implements DisposableSupplier<T> {
        private InitializableDisposableSupplier(DisposableSupplier<T> originalSupplier) {
            super(originalSupplier);
        }

        public void dispose(T instance) {
            ((DisposableSupplier)this.supplier).dispose(instance);
        }
    }
}

