/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.weld.internal.bean;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.PassivationCapable;
import jakarta.ws.rs.RuntimeType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import org.glassfish.jersey.inject.weld.internal.bean.JerseyBean;
import org.glassfish.jersey.inject.weld.internal.inject.InitializableSupplierInstanceBinding;
import org.jboss.weld.bean.StringBeanIdentifier;
import org.jboss.weld.bean.proxy.BeanInstance;
import org.jboss.weld.bean.proxy.ContextBeanInstance;
import org.jboss.weld.bean.proxy.ProxyFactory;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.serialization.spi.BeanIdentifier;

public class InitializableSupplierThreadScopeBean
extends JerseyBean<Object> {
    private final ThreadScopeBeanInstance<Object> beanInstance;
    private final InitializableSupplierInstanceBinding binding;
    private final Object proxy;

    InitializableSupplierThreadScopeBean(RuntimeType runtimeType, InitializableSupplierInstanceBinding binding, BeanManagerImpl manager) {
        super(runtimeType, binding);
        this.binding = binding;
        this.beanInstance = new ThreadScopeBeanInstance<Object>(binding.getSupplier(), this, manager.getContextId());
        this.proxy = this.createClientProxy((BeanInstance)this.beanInstance, manager.getContextId());
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    public Object create(CreationalContext<Object> ctx) {
        return this.proxy;
    }

    @Override
    public void destroy(Object instance, CreationalContext<Object> creationalContext) {
        this.beanInstance.dispose();
    }

    @Override
    public Class<?> getBeanClass() {
        return (Class)this.binding.getContracts().iterator().next();
    }

    private <T> T createClientProxy(BeanInstance beanInstance, String contextId) {
        ProxyFactory factory = new ProxyFactory(contextId, this.getBeanClass(), this.getTypes(), (Bean)this);
        return (T)factory.create(beanInstance);
    }

    private static class ThreadScopeBeanInstance<T>
    extends ContextBeanInstance<T> {
        private final WeakHashMap<Thread, Object> instances = new WeakHashMap();
        private final Supplier<T> supplier;

        private ThreadScopeBeanInstance(Supplier<T> supplier, Bean<T> bean, String contextId) {
            super(bean, (BeanIdentifier)new StringBeanIdentifier(((PassivationCapable)bean).getId()), contextId);
            this.supplier = supplier;
        }

        public Object invoke(Object obj, Method method, Object ... arguments) throws Throwable {
            Object instance = this.instances.computeIfAbsent(Thread.currentThread(), thread -> this.supplier.get());
            return super.invoke(instance, method, arguments);
        }

        public void dispose() {
            this.instances.clear();
        }
    }
}

