/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.weld.internal.injector;

import jakarta.enterprise.inject.InjectionException;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.Collection;
import java.util.logging.Logger;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.util.collection.LazyValue;
import org.glassfish.jersey.internal.util.collection.Values;

public class CachedConstructorAnalyzer<T> {
    private static final Logger LOGGER = Logger.getLogger(CachedConstructorAnalyzer.class.getName());
    private final LazyValue<Constructor<T>> constructor;
    private final Collection<Class<? extends Annotation>> resolverAnnotations;

    public CachedConstructorAnalyzer(Class<T> clazz, Collection<Class<? extends Annotation>> annotations) {
        this.resolverAnnotations = annotations;
        this.constructor = Values.lazy(() -> this.getConstructorInternal(clazz));
    }

    public Constructor<T> getConstructor() {
        return (Constructor)this.constructor.get();
    }

    public boolean hasCompatibleConstructor() {
        try {
            return this.constructor.get() != null;
        }
        catch (InjectionException ex) {
            return false;
        }
    }

    private Constructor<T> getConstructorInternal(Class<T> clazz) {
        if (clazz.isLocalClass()) {
            throw new InjectionException(LocalizationMessages.INJECTION_ERROR_LOCAL_CLASS_NOT_SUPPORTED((Object)clazz.getName()));
        }
        if (clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers())) {
            throw new InjectionException(LocalizationMessages.INJECTION_ERROR_NONSTATIC_MEMBER_CLASS_NOT_SUPPORTED((Object)clazz.getName()));
        }
        Constructor[] constructors = AccessController.doPrivileged(clazz::getDeclaredConstructors);
        Constructor selected = null;
        int selectedSize = 0;
        int maxParams = -1;
        for (Constructor constructor : constructors) {
            Class<?>[] params = constructor.getParameterTypes();
            if (params.length < maxParams || !this.isCompatible(constructor)) continue;
            if (params.length > maxParams) {
                maxParams = params.length;
                selectedSize = 0;
            }
            selected = constructor;
            ++selectedSize;
        }
        if (selectedSize == 0) {
            throw new InjectionException(LocalizationMessages.INJECTION_ERROR_SUITABLE_CONSTRUCTOR_NOT_FOUND((Object)clazz.getName()));
        }
        if (selectedSize > 1) {
            LOGGER.warning(LocalizationMessages.MULTIPLE_MATCHING_CONSTRUCTORS_FOUND((Object)selectedSize, (Object)maxParams, (Object)clazz.getName(), (Object)selected.toGenericString()));
        }
        return selected;
    }

    private boolean isCompatible(Constructor<?> constructor) {
        if (constructor.getAnnotation(Inject.class) != null) {
            return true;
        }
        int paramSize = constructor.getParameterTypes().length;
        if (paramSize != 0 && this.resolverAnnotations.isEmpty()) {
            return false;
        }
        if (!Modifier.isPublic(constructor.getModifiers())) {
            return paramSize == 0 && (constructor.getDeclaringClass().getModifiers() & 7) == constructor.getModifiers();
        }
        for (Annotation[] paramAnnotations : constructor.getParameterAnnotations()) {
            boolean found = false;
            for (Annotation paramAnnotation : paramAnnotations) {
                if (!this.resolverAnnotations.contains(paramAnnotation.annotationType())) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

