/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.weld.internal.bean;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.ws.rs.RuntimeType;
import java.lang.annotation.Annotation;
import org.glassfish.jersey.inject.weld.internal.bean.JerseyBean;
import org.glassfish.jersey.inject.weld.internal.inject.InitializableInstanceBinding;
import org.glassfish.jersey.inject.weld.internal.injector.JerseyClientCreationalContext;
import org.glassfish.jersey.inject.weld.internal.managed.CdiClientInjectionManager;
import org.glassfish.jersey.inject.weld.internal.managed.ContextSafe;

public class InitializableInstanceBean<T>
extends JerseyBean<T> {
    private InjectionTarget<T> injectionTarget;

    InitializableInstanceBean(RuntimeType runtimeType, InitializableInstanceBinding<T> binding) {
        super(runtimeType, binding);
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return this.getBinding().getScope() == null ? Dependent.class : InitializableInstanceBean.transformScope(this.getBinding().getScope());
    }

    public T create(CreationalContext<T> context) {
        InitializableInstanceBinding realBinding = (InitializableInstanceBinding)this.getBinding();
        if (JerseyClientCreationalContext.class.isInstance(context)) {
            realBinding = ((JerseyClientCreationalContext)context).getInjectionManager().getInjectionManagerBinding(realBinding);
        } else {
            CdiClientInjectionManager locked = ContextSafe.get();
            if (locked != null) {
                realBinding = locked.getInjectionManagerBinding(realBinding);
            }
        }
        Object service = realBinding.getService();
        this.injectionTarget.inject(service, context);
        return service;
    }

    @Override
    public Class<?> getBeanClass() {
        InitializableInstanceBinding binding = (InitializableInstanceBinding)this.getBinding();
        return binding.isInit() ? binding.getImplementationType() : Object.class;
    }

    void setInjectionTarget(InjectionTarget<T> injectionTarget) {
        this.injectionTarget = injectionTarget;
    }

    public String toString() {
        return this.getBinding().toString();
    }
}

