/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.weld.internal.inject;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.glassfish.jersey.inject.weld.internal.inject.InitializableInstanceBinding;
import org.glassfish.jersey.inject.weld.internal.inject.MatchableBinding;
import org.glassfish.jersey.innate.inject.InstanceBinding;
import org.glassfish.jersey.innate.inject.InternalBinding;
import org.glassfish.jersey.internal.inject.ServiceHolder;
import org.glassfish.jersey.internal.inject.ServiceHolderImpl;

public class InstanceListBinding<T>
extends MatchableBinding<List<T>, InitializableInstanceBinding<List<T>>>
implements Cloneable {
    private final Class<T> serviceType;
    private final List<InstanceBinding<T>> services = new ArrayList<InstanceBinding<T>>();

    public InstanceListBinding(Class<T> serviceType) {
        this.serviceType = serviceType;
    }

    @Override
    protected MatchableBinding.MatchLevel bestMatchLevel() {
        return MatchableBinding.MatchLevel.NEVER;
    }

    @Override
    public MatchableBinding.Matching<MatchableBinding> matching(InternalBinding other) {
        return MatchableBinding.Matching.noneMatching();
    }

    public void init(InstanceBinding<?> service) {
        this.services.add(service);
    }

    public List<T> getServices() {
        return this.services.stream().map(binding -> binding.getService()).collect(Collectors.toList());
    }

    public List<ServiceHolder<T>> getServiceHolders() {
        return this.services.stream().map(binding -> new ServiceHolderImpl(binding.getService(), this.serviceType, binding.getContracts(), binding.getRank() == null ? 0 : binding.getRank())).collect(Collectors.toList());
    }
}

