/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.weld.internal.inject;

import java.lang.reflect.Type;
import java.util.Set;
import org.glassfish.jersey.inject.weld.internal.inject.InitializableInstanceBinding;
import org.glassfish.jersey.inject.weld.internal.inject.InitializableSupplierInstanceBinding;
import org.glassfish.jersey.innate.inject.InstanceBinding;
import org.glassfish.jersey.innate.inject.InternalBinding;
import org.glassfish.jersey.innate.inject.SupplierInstanceBinding;

public abstract class MatchableBinding<T, D extends MatchableBinding>
extends InternalBinding<T, D> {
    protected static MatchingVisitor visitor = new MatchingVisitor();

    protected abstract MatchLevel bestMatchLevel();

    public abstract Matching<MatchableBinding> matching(InternalBinding var1);

    protected Matching<D> matches(InternalBinding<?, ?> other) {
        if (this.getId() != 0L) {
            return this.matchesById(other);
        }
        Matching<D> matching = this.matchesContracts(other);
        if (matching.matchLevel == MatchLevel.FULL_CONTRACT && this.getImplementationType().equals(other.getImplementationType())) {
            matching.matchLevel = MatchLevel.IMPLEMENTATION;
        }
        return matching;
    }

    protected Matching matchesById(InternalBinding<?, ?> other) {
        if (this.getId() == other.getId()) {
            return new Matching<MatchableBinding>(this, MatchLevel.FULL_CONTRACT);
        }
        return Matching.noneMatching();
    }

    public Matching<D> matchesContracts(InternalBinding<?, ?> other) {
        boolean atLeastOneMatch = false;
        boolean allMatch = true;
        Set firstContracts = this.getContracts();
        Set secondContracts = other.getContracts();
        Set biggerContracts = firstContracts.size() < secondContracts.size() ? secondContracts : firstContracts;
        Set smallerContracts = firstContracts.size() < secondContracts.size() ? firstContracts : secondContracts;
        for (Type thisType : biggerContracts) {
            boolean aMatch = false;
            for (Type otherType : smallerContracts) {
                if (!thisType.equals(otherType)) continue;
                aMatch = true;
                atLeastOneMatch = true;
                break;
            }
            if (aMatch) continue;
            allMatch = false;
        }
        MatchLevel matchLevel = atLeastOneMatch ? (allMatch ? MatchLevel.FULL_CONTRACT : MatchLevel.PARTIAL_CONTRACT) : MatchLevel.NONE;
        Matching<MatchableBinding> matching = new Matching<MatchableBinding>(this, matchLevel);
        return matching;
    }

    public static class Matching<D extends MatchableBinding>
    implements Comparable<Matching> {
        private D binding;
        protected MatchLevel matchLevel;

        public static <D extends MatchableBinding> Matching<D> noneMatching() {
            return new Matching<Object>(null, MatchLevel.NONE);
        }

        protected Matching(D binding, MatchLevel matchLevel) {
            this.binding = binding;
            this.matchLevel = matchLevel;
        }

        @Override
        public int compareTo(Matching other) {
            return other.matchLevel.level - this.matchLevel.level;
        }

        public Matching better(Matching other) {
            return this.compareTo(other) <= 0 ? this : other;
        }

        public boolean isBest() {
            return this.matches() && this.matchLevel == ((MatchableBinding)((Object)this.binding)).bestMatchLevel();
        }

        public boolean matches() {
            return this.matchLevel.level > MatchLevel.NONE.level;
        }

        public D getBinding() {
            return this.binding;
        }

        public Matching<D> clone() {
            return new Matching<D>(this.binding, this.matchLevel);
        }
    }

    protected static enum MatchLevel {
        NONE(0),
        PARTIAL_CONTRACT(1),
        FULL_CONTRACT(2),
        IMPLEMENTATION(3),
        SUPPLIER(4),
        NEVER(5);

        private final int level;

        private MatchLevel(int level) {
            this.level = level;
        }
    }

    protected static class MatchingVisitor<D extends MatchableBinding<?, D>> {
        protected MatchingVisitor() {
        }

        public Matching<InitializableInstanceBinding<D>> matches(InitializableInstanceBinding<D> binding, InternalBinding other) {
            return binding.matches((InternalBinding)((InstanceBinding)other));
        }

        public Matching<InitializableSupplierInstanceBinding<D>> matches(InitializableSupplierInstanceBinding<D> binding, InternalBinding other) {
            return binding.matches((SupplierInstanceBinding)other);
        }

        public Matching<MatchableBinding<?, D>> matches(MatchableBinding<?, D> binding, InternalBinding other) {
            throw new IllegalStateException("Unexpected");
        }
    }
}

