/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.weld.internal.managed;

import org.glassfish.jersey.inject.weld.internal.managed.CdiClientInjectionManager;

public final class ContextSafe {
    private static final ThreadLocal<CdiClientInjectionManager> CURRENT_CONTEXT = new ThreadLocal();

    public static void lockContext(CdiClientInjectionManager current) {
        CURRENT_CONTEXT.set(current);
    }

    public static CdiClientInjectionManager get() {
        return CURRENT_CONTEXT.get();
    }

    public static void unlock(CdiClientInjectionManager locked) {
        CdiClientInjectionManager ctx = CURRENT_CONTEXT.get();
        if (ctx != locked) {
            throw new IllegalStateException("The CreationalContext safe has been compromised");
        }
        CURRENT_CONTEXT.remove();
    }
}

