/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.weld.internal.bean;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.ws.rs.RuntimeType;
import java.lang.annotation.Annotation;
import java.util.function.Supplier;
import org.glassfish.jersey.inject.weld.internal.bean.JerseyBean;
import org.glassfish.jersey.inject.weld.internal.inject.InitializableSupplierInstanceBinding;
import org.glassfish.jersey.inject.weld.internal.injector.JerseyClientCreationalContext;
import org.glassfish.jersey.inject.weld.internal.managed.CdiClientInjectionManager;
import org.glassfish.jersey.inject.weld.internal.managed.ContextSafe;
import org.glassfish.jersey.internal.inject.DisposableSupplier;

class InitializableSupplierInstanceBeanBridge<T>
extends JerseyBean<Object> {
    private final Supplier<T> supplier;
    private final Class<? extends Annotation> scope;

    InitializableSupplierInstanceBeanBridge(RuntimeType runtimeType, InitializableSupplierInstanceBinding binding) {
        super(runtimeType, binding);
        InitializableSupplierInstanceBinding casted = binding;
        this.supplier = casted.getSupplier();
        this.scope = casted.getScope();
    }

    public Object create(CreationalContext creationalContext) {
        if (JerseyClientCreationalContext.class.isInstance(creationalContext)) {
            InitializableSupplierInstanceBinding binding = (InitializableSupplierInstanceBinding)this.getBinding();
            JerseyClientCreationalContext jerseyContext = (JerseyClientCreationalContext)creationalContext;
            return jerseyContext.getInjectionManager().getInjectionManagerBinding(binding).getSupplier().get();
        }
        CdiClientInjectionManager locked = ContextSafe.get();
        if (locked != null) {
            return locked.getInjectionManagerBinding((InitializableSupplierInstanceBinding)this.getBinding()).getSupplier().get();
        }
        return this.supplier.get();
    }

    @Override
    public void destroy(Object instance, CreationalContext<Object> context) {
        if (DisposableSupplier.class.isAssignableFrom(this.supplier.getClass())) {
            ((DisposableSupplier)this.supplier).dispose(instance);
        }
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return this.scope == null ? Dependent.class : InitializableSupplierInstanceBeanBridge.transformScope(this.scope);
    }
}

