/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.weld.internal.inject;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.glassfish.jersey.innate.inject.ClassBinding;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.ServiceHolder;
import org.glassfish.jersey.internal.inject.ServiceHolderImpl;
import org.glassfish.jersey.internal.util.collection.LazyValue;
import org.glassfish.jersey.internal.util.collection.Values;

public class ClassListBinding<T> {
    private final Class<T> serviceType;
    private final List<ClassBinding<T>> services = new ArrayList<ClassBinding<T>>();
    private final InjectionManager injectionManager;
    private final LazyValue<List<ServiceHolder<T>>> instances;

    public ClassListBinding(Class<T> serviceType, InjectionManager injectionManager) {
        this.serviceType = serviceType;
        this.injectionManager = injectionManager;
        this.instances = Values.lazy(() -> this.services.stream().map(binding -> new ServiceHolderImpl(this.create((ClassBinding<T>)binding), binding.getService().getClass(), binding.getContracts(), binding.getRank() == null ? 0 : binding.getRank())).map(sh -> sh).collect(Collectors.toList()));
    }

    private T create(ClassBinding<T> binding) {
        Object t = this.injectionManager.createAndInitialize(binding.getService());
        return (T)t;
    }

    public void init(ClassBinding<?> service) {
        this.services.add(service);
    }

    public List<T> getServices() {
        return ((List)this.instances.get()).stream().map(sh -> sh.getInstance()).collect(Collectors.toList());
    }

    public List<ServiceHolder<T>> getServiceHolders() {
        return (List)this.instances.get();
    }

    public String toString() {
        return super.toString();
    }
}

