/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.weld.internal.inject;

import jakarta.ws.rs.RuntimeType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glassfish.jersey.inject.weld.internal.inject.InitializableBinding;
import org.glassfish.jersey.inject.weld.internal.inject.MatchableBinding;
import org.glassfish.jersey.innate.inject.InstanceBinding;
import org.glassfish.jersey.innate.inject.InternalBinding;
import org.glassfish.jersey.internal.inject.AliasBinding;

public class InitializableInstanceBinding<T>
extends InitializableBinding<T, InitializableInstanceBinding<T>>
implements Cloneable {
    protected T service;
    private final AtomicBoolean isInit = new AtomicBoolean(false);
    private Class<T> implementationType;
    private final RuntimeType runtimeType;

    protected InitializableInstanceBinding(T service, RuntimeType runtimeType) {
        this(service, null, runtimeType);
    }

    private InitializableInstanceBinding(T service, Type contractType, RuntimeType runtimeType) {
        this.service = service;
        Class<Object> clazz = this.implementationType = service == null ? null : service.getClass();
        if (contractType != null) {
            this.to(contractType);
        }
        this.runtimeType = runtimeType;
    }

    public T getService() {
        if (!this.isInit.get()) {
            String types = Arrays.toString(this.getContracts().toArray());
            throw new IllegalStateException("Not initialized " + this.service + "(" + types + ")");
        }
        return this.service;
    }

    public Class<T> getImplementationType() {
        return this.implementationType;
    }

    public void init(T service) {
        if (!this.isInit.getAndSet(true)) {
            this.service = service;
            this.implementationType = service.getClass();
        } else if (this.service != service) {
            throw new IllegalStateException("Multiple initialized for " + service.getClass());
        }
    }

    @Override
    public boolean isInit() {
        return this.isInit.get();
    }

    @Override
    public RuntimeType getRuntimeType() {
        return this.runtimeType;
    }

    @Override
    public MatchableBinding.Matching<InitializableInstanceBinding<T>> matches(InternalBinding other) {
        return super.matches(other);
    }

    public InitializableInstanceBinding<T> clone() {
        throw new RuntimeException(new CloneNotSupportedException());
    }

    public static <T> InitializableInstanceBinding<T> from(InstanceBinding<T> instanceBinding, RuntimeType runtimeType) {
        return new InitializableWrappingInstanceBinding<T>(instanceBinding, runtimeType);
    }

    @Override
    protected MatchableBinding.MatchLevel bestMatchLevel() {
        return MatchableBinding.MatchLevel.IMPLEMENTATION;
    }

    @Override
    public MatchableBinding.Matching<MatchableBinding> matching(InternalBinding other) {
        return visitor.matches(this, other);
    }

    public int hashCode() {
        return Objects.hash(this.service, this.implementationType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InitializableInstanceBinding that = (InitializableInstanceBinding)o;
        return Objects.equals(this.service, that.service) && Objects.equals(this.implementationType, that.implementationType);
    }

    private static class InitializableWrappingInstanceBinding<T>
    extends InitializableInstanceBinding<T> {
        private final InstanceBinding<T> wrapped;

        public InitializableWrappingInstanceBinding(InstanceBinding<T> binding, RuntimeType runtimeType) {
            super(binding.getService(), runtimeType);
            this.wrapped = binding;
            this.postCreate();
        }

        private InitializableWrappingInstanceBinding(InitializableWrappingInstanceBinding<T> binding, RuntimeType runtimeType) {
            super(binding.service, runtimeType);
            this.wrapped = binding.wrapped;
            this.postCreate();
        }

        private void postCreate() {
            this.wrapped.getContracts().forEach(c -> this.to((Type)c));
            if (this.wrapped.getRank() != null) {
                this.ranked(this.wrapped.getRank());
            }
            this.named(this.wrapped.getName());
            this.id(this.wrapped.getId());
            this.in(this.wrapped.getScope());
            this.forClient(this.wrapped.isForClient());
        }

        public Set<AliasBinding> getAliases() {
            return this.wrapped.getAliases();
        }

        public Set<Annotation> getQualifiers() {
            return this.wrapped.getQualifiers();
        }

        public String getAnalyzer() {
            return this.wrapped.getAnalyzer();
        }

        public String getName() {
            return this.wrapped.getName();
        }

        public String toString() {
            return this.wrapped.toString();
        }

        @Override
        public InitializableWrappingInstanceBinding clone() {
            return new InitializableWrappingInstanceBinding<T>(this, this.getRuntimeType());
        }
    }
}

