/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.weld.internal.inject;

import jakarta.ws.rs.RuntimeType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.glassfish.jersey.inject.weld.internal.inject.InitializableBinding;
import org.glassfish.jersey.inject.weld.internal.inject.MatchableBinding;
import org.glassfish.jersey.innate.inject.InternalBinding;
import org.glassfish.jersey.innate.inject.SupplierInstanceBinding;
import org.glassfish.jersey.internal.inject.AliasBinding;
import org.glassfish.jersey.internal.inject.DisposableSupplier;

public class InitializableSupplierInstanceBinding<T>
extends InitializableBinding<Supplier<T>, InitializableSupplierInstanceBinding<T>>
implements Cloneable {
    private final InitializableSupplier<T> supplier;
    private final RuntimeType runtimeType;

    public InitializableSupplierInstanceBinding(Supplier<T> supplier, RuntimeType runtimeType) {
        this.supplier = DisposableSupplier.class.isInstance(supplier) ? new InitializableDisposableSupplier((DisposableSupplier)supplier) : new InitializableSupplier<T>(supplier);
        this.runtimeType = runtimeType;
        if ("EmptyReferenceFactory".equals(supplier.getClass().getSimpleName())) {
            this.supplier.init(supplier);
            this.supplier.isReferencingFactory = true;
        }
        if ("InitializedReferenceFactory".equals(supplier.getClass().getSimpleName())) {
            this.supplier.init(supplier);
            this.supplier.isReferencingFactory = true;
        }
        T t = supplier.get();
    }

    public void init(Supplier<T> supplier) {
        this.supplier.init(supplier);
    }

    @Override
    public boolean isInit() {
        return this.supplier.init.get();
    }

    @Override
    public RuntimeType getRuntimeType() {
        return this.runtimeType;
    }

    public Supplier<T> getSupplier() {
        return this.supplier;
    }

    public Supplier<T> getOriginalSupplier() {
        if (this.supplier.originalSupplier == null) {
            throw new IllegalStateException("Supplier must not be null");
        }
        return this.supplier.originalSupplier;
    }

    public static <T> InitializableSupplierInstanceBinding<T> from(SupplierInstanceBinding<T> binding, RuntimeType runtimeType) {
        return new InitializableSupplierWrappingInstanceBinding(binding, runtimeType);
    }

    public InitializableSupplierInstanceBinding clone() {
        throw new RuntimeException(new CloneNotSupportedException());
    }

    public MatchableBinding.Matching matches(SupplierInstanceBinding<T> other) {
        return this.matches(this.getOriginalSupplier().getClass(), other.getSupplier().getClass(), (InternalBinding)other);
    }

    public MatchableBinding.Matching matches(InitializableSupplierInstanceBinding<T> other) {
        return this.matches(this.getOriginalSupplier().getClass(), other.getSupplier().getClass(), other);
    }

    private MatchableBinding.Matching<InitializableSupplierInstanceBinding<T>> matches(Class<?> originalSupplierClass, Class<?> otherSupplierClass, InternalBinding other) {
        if (this.getId() != 0L) {
            return this.matchesById(other);
        }
        boolean matchesService = originalSupplierClass.equals(otherSupplierClass);
        MatchableBinding.Matching<InitializableSupplierInstanceBinding<T>> matching = this.matchesContracts(other);
        if (matching.matchLevel == MatchableBinding.MatchLevel.FULL_CONTRACT && matchesService) {
            matching.matchLevel = MatchableBinding.MatchLevel.SUPPLIER;
        }
        return matching;
    }

    @Override
    protected MatchableBinding.MatchLevel bestMatchLevel() {
        return MatchableBinding.MatchLevel.SUPPLIER;
    }

    @Override
    public MatchableBinding.Matching<MatchableBinding> matching(InternalBinding other) {
        return visitor.matches(this, other);
    }

    private static class InitializableDisposableSupplier<T>
    extends InitializableSupplier<T>
    implements DisposableSupplier<T> {
        private InitializableDisposableSupplier(DisposableSupplier<T> originalSupplier) {
            super(originalSupplier);
        }

        public void dispose(T instance) {
            if (this.isInit()) {
                ((DisposableSupplier)this.supplier).dispose(instance);
            }
        }
    }

    private static class InitializableSupplier<T>
    implements Supplier<T> {
        private AtomicBoolean init = new AtomicBoolean(false);
        protected Supplier<T> supplier;
        protected final Supplier<T> originalSupplier;
        private boolean isReferencingFactory = false;

        private InitializableSupplier(Supplier<T> originalSupplier) {
            this.originalSupplier = originalSupplier;
        }

        private void init(Supplier<T> supply) {
            if (!this.init.getAndSet(true)) {
                this.supplier = supply;
            } else if (!this.isReferencingFactory && this.supplier != supply) {
                throw new IllegalStateException("Multiple initialized for " + this.originalSupplier.getClass());
            }
        }

        @Override
        public T get() {
            if (!this.init.get()) {
                throw new IllegalStateException("Not initialized" + this.originalSupplier.getClass());
            }
            return this.supplier.get();
        }

        public boolean isInit() {
            return this.init.get();
        }
    }

    private static class InitializableSupplierWrappingInstanceBinding<T>
    extends InitializableSupplierInstanceBinding<T> {
        private final SupplierInstanceBinding wrapped;

        InitializableSupplierWrappingInstanceBinding(SupplierInstanceBinding binding, RuntimeType runtimeType) {
            super(binding.getSupplier(), runtimeType);
            this.wrapped = binding;
            this.postCreate();
        }

        private InitializableSupplierWrappingInstanceBinding(InitializableSupplierWrappingInstanceBinding binding, RuntimeType runtimeType) {
            super(binding.getOriginalSupplier(), runtimeType);
            this.wrapped = binding.wrapped;
            this.postCreate();
        }

        private void postCreate() {
            this.wrapped.getContracts().forEach(c -> this.to((Type)c));
            if (this.wrapped.getRank() != null) {
                this.ranked(this.wrapped.getRank());
            }
            this.named(this.wrapped.getName());
            this.id(this.wrapped.getId());
            this.in(this.wrapped.getScope());
            this.forClient(this.wrapped.isForClient());
        }

        public Set<AliasBinding> getAliases() {
            return this.wrapped.getAliases();
        }

        public Set<Annotation> getQualifiers() {
            return this.wrapped.getQualifiers();
        }

        public String getAnalyzer() {
            return this.wrapped.getAnalyzer();
        }

        public String toString() {
            return this.wrapped.toString();
        }

        @Override
        public InitializableSupplierWrappingInstanceBinding clone() {
            return new InitializableSupplierWrappingInstanceBinding<T>(this, this.getRuntimeType());
        }
    }
}

