/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.weld.internal.injector;

import jakarta.decorator.Decorator;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.InjectionException;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.interceptor.Interceptor;
import jakarta.ws.rs.WebApplicationException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import org.glassfish.jersey.inject.weld.internal.bean.BeanHelper;
import org.glassfish.jersey.inject.weld.internal.bean.JerseyBean;
import org.glassfish.jersey.inject.weld.internal.injector.JerseyInstanceInjector;
import org.glassfish.jersey.inject.weld.internal.injector.JerseyTwofoldInstantiator;
import org.glassfish.jersey.inject.weld.managed.CdiInjectionManagerFactory;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.InjectionResolver;
import org.glassfish.jersey.internal.util.collection.LazyValue;
import org.glassfish.jersey.internal.util.collection.Values;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedConstructor;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.CustomDecoratorWrapper;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.bean.proxy.ProxyInstantiator;
import org.jboss.weld.injection.producer.AbstractInstantiator;
import org.jboss.weld.injection.producer.BasicInjectionTarget;
import org.jboss.weld.injection.producer.ConstructorInterceptionInstantiator;
import org.jboss.weld.injection.producer.DefaultInstantiator;
import org.jboss.weld.injection.producer.Instantiator;
import org.jboss.weld.injection.producer.InterceptionModelInitializer;
import org.jboss.weld.injection.producer.InterceptorApplyingInstantiator;
import org.jboss.weld.injection.producer.SubclassDecoratorApplyingInstantiator;
import org.jboss.weld.injection.producer.SubclassedComponentInstantiator;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.reflection.Formats;

public class JerseyInjectionTarget<T>
extends BasicInjectionTarget<T> {
    private final Bean<T> bean;
    private final Class<T> clazz;
    private final LazyValue<JerseyInstanceInjector<T>> injector;
    private final EnhancedAnnotatedType<T> enhancedAnnotatedType;
    private Collection<InjectionResolver> resolvers;
    private BasicInjectionTarget delegate;
    private final Instantiator<T> instantiator;

    public JerseyInjectionTarget(BasicInjectionTarget<T> delegate, Class<T> clazz) {
        this(delegate, delegate.getBean(), clazz, null);
    }

    public JerseyInjectionTarget(BasicInjectionTarget<T> delegate, Bean<T> bean, Class<T> clazz, Collection<InjectionResolver> resolvers) {
        this(BeanHelper.createEnhancedAnnotatedType(delegate), delegate, bean, clazz, resolvers, delegate.getInstantiator());
        this.delegate = delegate;
        this.setInstantiator(this.instantiator);
    }

    public JerseyInjectionTarget(EnhancedAnnotatedType<T> annotatedType, BasicInjectionTarget<T> delegate, Bean<T> bean, Class<T> clazz, Collection<InjectionResolver> resolvers, Instantiator<T> instantiator) {
        super(annotatedType, bean, delegate.getBeanManager(), delegate.getInjector(), delegate.getLifecycleCallbackInvoker(), JerseyBean.class.isInstance(bean) ? new JerseyTwofoldInstantiator((AbstractInstantiator)instantiator) : instantiator);
        this.bean = bean;
        this.enhancedAnnotatedType = annotatedType;
        this.clazz = clazz;
        this.resolvers = resolvers;
        this.injector = Values.lazy(() -> new JerseyInstanceInjector(bean, this.resolvers));
        this.delegate = null;
        this.instantiator = this.getInstantiator();
        this.setInstantiator(this.instantiator);
    }

    protected void checkDelegateInjectionPoints() {
        if (this.getAnnotatedType().getAnnotation(Decorator.class) == null) {
            super.checkDelegateInjectionPoints();
        }
    }

    public void inject(T instance, CreationalContext<T> ctx) {
        try {
            ((JerseyInstanceInjector)this.injector.get()).inject(instance);
        }
        catch (WebApplicationException wae) {
            throw wae;
        }
        catch (Throwable cause) {
            throw new InjectionException("Exception occurred during Jersey/JAX-RS annotations processing in the class: " + this.clazz, cause);
        }
        super.inject(instance, ctx);
    }

    public void initializeAfterBeanDiscovery(EnhancedAnnotatedType<T> annotatedType) {
        boolean hasDecorators;
        this.initializeInterceptionModel(annotatedType);
        InterceptionModel interceptionModel = null;
        if (this.isInterceptionCandidate()) {
            interceptionModel = (InterceptionModel)this.beanManager.getInterceptorModelRegistry().get(this.getType());
        }
        boolean hasNonConstructorInterceptors = interceptionModel != null && (interceptionModel.hasExternalNonConstructorInterceptors() || interceptionModel.hasTargetClassInterceptors());
        List decorators = null;
        if (this.getBean() != null && this.isInterceptionCandidate()) {
            decorators = this.beanManager.resolveDecorators(this.getBean().getTypes(), this.getBean().getQualifiers());
        }
        boolean bl = hasDecorators = decorators != null && !decorators.isEmpty();
        if (hasDecorators) {
            this.checkDecoratedMethods(annotatedType, decorators);
        }
        if (hasNonConstructorInterceptors || hasDecorators) {
            if (!(this.getInstantiator() instanceof DefaultInstantiator)) {
                throw new IllegalStateException("Unexpected instantiator " + this.getInstantiator());
            }
            AbstractInstantiator delegate = (AbstractInstantiator)this.getInstantiator();
            this.setInstantiator((Instantiator<T>)SubclassedComponentInstantiator.forInterceptedDecoratedBean(annotatedType, this.getBean(), (AbstractInstantiator)delegate, (BeanManagerImpl)this.beanManager));
            if (hasDecorators) {
                this.setInstantiator((Instantiator<T>)new SubclassDecoratorApplyingInstantiator(this.getBeanManager().getContextId(), this.getInstantiator(), this.getBean(), decorators));
            }
            if (hasNonConstructorInterceptors) {
                this.setInstantiator((Instantiator<T>)new InterceptorApplyingInstantiator(this.getInstantiator(), interceptionModel, this.getType()));
            }
        }
        if (this.isInterceptionCandidate()) {
            this.setupConstructorInterceptionInstantiator(interceptionModel);
        }
    }

    private void setupConstructorInterceptionInstantiator(InterceptionModel interceptionModel) {
        if (interceptionModel != null && interceptionModel.hasExternalConstructorInterceptors()) {
            this.setInstantiator((Instantiator<T>)new ConstructorInterceptionInstantiator(this.getInstantiator(), interceptionModel, this.getType()));
        }
    }

    private void checkNoArgsConstructor(EnhancedAnnotatedType<T> type) {
        if (!((ProxyInstantiator)this.beanManager.getServices().get(ProxyInstantiator.class)).isUsingConstructor()) {
            return;
        }
        EnhancedAnnotatedConstructor constructor = type.getNoArgsEnhancedConstructor();
        if (constructor == null) {
            throw BeanLogger.LOG.decoratedHasNoNoargsConstructor((Object)this);
        }
        if (constructor.isPrivate()) {
            throw BeanLogger.LOG.decoratedNoargsConstructorIsPrivate((Object)this, (Object)Formats.formatAsStackTraceElement((Member)constructor.getJavaMember()));
        }
    }

    private void checkDecoratedMethods(EnhancedAnnotatedType<T> type, List<jakarta.enterprise.inject.spi.Decorator<?>> decorators) {
        if (type.isFinal()) {
            throw BeanLogger.LOG.finalBeanClassWithDecoratorsNotAllowed((Object)this);
        }
        this.checkNoArgsConstructor(type);
        for (jakarta.enterprise.inject.spi.Decorator<?> decorator : decorators) {
            EnhancedAnnotatedType decoratorClass;
            if (decorator instanceof DecoratorImpl) {
                DecoratorImpl decoratorBean = (DecoratorImpl)decorator;
                decoratorClass = ((ClassTransformer)decoratorBean.getBeanManager().getServices().get(ClassTransformer.class)).getEnhancedAnnotatedType(decoratorBean.getAnnotated());
            } else if (decorator instanceof CustomDecoratorWrapper) {
                decoratorClass = ((CustomDecoratorWrapper)decorator).getEnhancedAnnotated();
            } else {
                throw BeanLogger.LOG.nonContainerDecorator(decorator);
            }
            for (EnhancedAnnotatedMethod decoratorMethod : decoratorClass.getEnhancedMethods()) {
                EnhancedAnnotatedMethod method = type.getEnhancedMethod(decoratorMethod.getSignature());
                if (method == null || method.isStatic() || method.isPrivate() || !method.isFinal()) continue;
                throw BeanLogger.LOG.finalBeanClassWithInterceptorsNotAllowed((Object)this);
            }
        }
    }

    private void initializeInterceptionModel(EnhancedAnnotatedType<T> annotatedType) {
        AbstractInstantiator instantiator = (AbstractInstantiator)this.getInstantiator();
        if (instantiator.getConstructorInjectionPoint() == null) {
            return;
        }
        if (this.isInterceptionCandidate() && !this.beanManager.getInterceptorModelRegistry().containsKey(this.getType())) {
            this.buildInterceptionModel(annotatedType, instantiator);
        }
    }

    private void buildInterceptionModel(EnhancedAnnotatedType<T> annotatedType, AbstractInstantiator<T> instantiator) {
        new InterceptionModelInitializer(this.beanManager, annotatedType, annotatedType.getDeclaredEnhancedConstructor(instantiator.getConstructorInjectionPoint().getSignature()), this.getBean()).init();
    }

    private boolean isInterceptor() {
        return this.getBean() instanceof jakarta.enterprise.inject.spi.Interceptor || this.getType().isAnnotationPresent(Interceptor.class);
    }

    private boolean isDecorator() {
        return this.getBean() instanceof jakarta.enterprise.inject.spi.Decorator || this.getType().isAnnotationPresent(Decorator.class);
    }

    private boolean isInterceptionCandidate() {
        return !this.isInterceptor() && !this.isDecorator() && !Modifier.isAbstract(this.getType().getJavaClass().getModifiers());
    }

    public T produce(CreationalContext<T> ctx) {
        Object instance;
        if (this.delegate != null) {
            instance = this.delegate.produce(ctx);
        } else {
            instance = super.produce(ctx);
            if (this.bean != null && !this.bean.getScope().equals(Dependent.class) && !this.getInstantiator().hasDecoratorSupport()) {
                ctx.push(instance);
            }
        }
        if (CdiInjectionManagerFactory.SUPPORT_CONTEXT) {
            InjectionManager injectionManager = CdiInjectionManagerFactory.getInjectionManager(ctx);
            injectionManager.inject(instance, "CONTEXT");
        }
        return (T)instance;
    }

    public Instantiator<T> getInstantiator() {
        return this.delegate != null ? this.delegate.getInstantiator() : super.getInstantiator();
    }

    public void setInstantiator(Instantiator<T> instantiator) {
        if (this.delegate != null) {
            this.delegate.setInstantiator(instantiator);
        } else {
            super.setInstantiator(instantiator);
        }
    }

    public Bean<T> getBean() {
        return this.bean;
    }

    public void setInjectionResolvers(Collection<InjectionResolver> resolvers) {
        this.resolvers = resolvers;
    }

    public EnhancedAnnotatedType<T> getEnhancedAnnotatedType() {
        return this.enhancedAnnotatedType;
    }

    public JerseyTwofoldInstantiator<T> getTwofoldInstantiator() {
        return (JerseyTwofoldInstantiator)this.instantiator;
    }
}

