/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.weld.internal.managed;

import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.NormalScope;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessInjectionTarget;
import jakarta.enterprise.inject.spi.Unmanaged;
import jakarta.enterprise.inject.spi.WithAnnotations;
import jakarta.inject.Scope;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.glassfish.jersey.inject.weld.internal.bean.BeanHelper;
import org.glassfish.jersey.inject.weld.internal.data.BindingBeanPair;
import org.glassfish.jersey.inject.weld.internal.inject.InitializableInstanceBinding;
import org.glassfish.jersey.inject.weld.internal.inject.InitializableSupplierInstanceBinding;
import org.glassfish.jersey.inject.weld.internal.injector.ContextInjectionResolverImpl;
import org.glassfish.jersey.inject.weld.internal.injector.JerseyInjectionTarget;
import org.glassfish.jersey.inject.weld.internal.managed.CdiClientInjectionManager;
import org.glassfish.jersey.inject.weld.internal.managed.CdiInjectionManager;
import org.glassfish.jersey.inject.weld.internal.managed.CdiInjectionManagerFactoryBase;
import org.glassfish.jersey.inject.weld.internal.managed.WrappingInjectionManager;
import org.glassfish.jersey.inject.weld.internal.scope.CdiRequestScope;
import org.glassfish.jersey.inject.weld.internal.scope.RequestScopeBean;
import org.glassfish.jersey.innate.BootstrapPreinitialization;
import org.glassfish.jersey.innate.inject.Bindings;
import org.glassfish.jersey.innate.inject.ClassBinding;
import org.glassfish.jersey.innate.inject.InjectionResolverBinding;
import org.glassfish.jersey.innate.inject.InstanceBinding;
import org.glassfish.jersey.innate.inject.InternalBinder;
import org.glassfish.jersey.innate.inject.InternalBinding;
import org.glassfish.jersey.innate.inject.SupplierClassBinding;
import org.glassfish.jersey.innate.inject.SupplierInstanceBinding;
import org.glassfish.jersey.internal.BootstrapBag;
import org.glassfish.jersey.internal.ServiceFinder;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.Binding;
import org.glassfish.jersey.internal.inject.CustomAnnotationLiteral;
import org.glassfish.jersey.internal.inject.ForeignDescriptor;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.InjectionResolver;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.inject.ServiceHolder;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.internal.util.collection.Refs;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ResourceConfig;
import org.jboss.weld.injection.producer.BasicInjectionTarget;
import org.jboss.weld.injection.producer.BeanInjectionTarget;

class BinderRegisterExtension
implements Extension {
    private final AtomicBoolean registrationDone = new AtomicBoolean(false);
    private Supplier<BeanManager> beanManagerSupplier;
    private final Ref<InjectionManager> serverInjectionManager = Refs.emptyRef();
    private final BootstrapInjectionManager clientBootstrapInjectionManager = new BootstrapInjectionManager(RuntimeType.CLIENT);
    private final WrappingInjectionManager serverBootstrapInjectionManager = new WrappingInjectionManager().setInjectionManager(new BootstrapInjectionManager(RuntimeType.SERVER));
    private final BootstrapBag bootstrapBag = new BootstrapBag();
    private final List<InitializableInstanceBinding> skippedClientInstanceBindings = new ArrayList<InitializableInstanceBinding>();
    private final List<InitializableSupplierInstanceBinding> skippedClientSupplierInstanceBindings = new ArrayList<InitializableSupplierInstanceBinding>();
    private final CachingBinder clientBindings = new CachingBinder(this.serverInjectionManager, RuntimeType.CLIENT){};
    private final CachingBinder serverBindings = new CachingBinder(this.serverInjectionManager, RuntimeType.SERVER){

        @Override
        protected void configure() {
            this.install(new Binder[]{new ContextInjectionResolverImpl.Binder(BinderRegisterExtension.this.beanManagerSupplier)});
            this.bind((Binding)InitializableInstanceBinding.from((InstanceBinding)Bindings.service((Object)((InjectionManager)BinderRegisterExtension.this.serverInjectionManager.get())).to(InjectionManager.class), RuntimeType.SERVER));
        }
    };
    private final CachingBinder annotatedBeansBinder = new CachingBinder(this.serverInjectionManager, null);
    private final MergedBindings mergedBindings = new MergedBindings(this.serverBindings, this.clientBindings);
    private final List<InitializableInstanceBinding> initializableInstanceBindings = new LinkedList<InitializableInstanceBinding>();
    private final List<InitializableSupplierInstanceBinding> initializableSupplierInstanceBindings = new LinkedList<InitializableSupplierInstanceBinding>();
    private final MultivaluedMap<Type, BindingBeanPair> supplierClassBindings = new MultivaluedHashMap();
    private final MultivaluedMap<Type, BindingBeanPair> classBindings = new MultivaluedHashMap();
    private final List<JerseyInjectionTarget> jerseyInjectionTargets = new LinkedList<JerseyInjectionTarget>();
    private final List<InjectionResolver> injectionResolvers = new LinkedList<InjectionResolver>();
    private final Map<Class<?>, Class<? extends Annotation>> annotatedBeans = new HashMap();
    private final List<Class<Application>> applications = new LinkedList<Class<Application>>();
    final Set<Class<?>> managedBeans = new HashSet();

    BinderRegisterExtension() {
    }

    <T> void ignoreManuallyRegisteredComponents(@Observes @WithAnnotations(value={Path.class, Provider.class}) ProcessAnnotatedType<T> pat) {
        AnnotatedType annotatedType = pat.getAnnotatedType();
        for (Binding binding : this.mergedBindings.getBindings()) {
            if (ClassBinding.class.isAssignableFrom(binding.getClass())) {
                ClassBinding classBinding = (ClassBinding)binding;
                if (annotatedType.getJavaClass() != classBinding.getService()) continue;
                pat.veto();
                return;
            }
            if (!InstanceBinding.class.isAssignableFrom(binding.getClass())) continue;
            InstanceBinding instanceBinding = (InstanceBinding)binding;
            if (annotatedType.getJavaClass() != instanceBinding.getService().getClass()) continue;
            pat.veto();
            return;
        }
        if (annotatedType.isAnnotationPresent(Path.class)) {
            boolean hasScope = false;
            for (Annotation annotation : annotatedType.getAnnotations()) {
                if (!annotation.annotationType().isAnnotationPresent(Scope.class) && !annotation.annotationType().isAnnotationPresent(NormalScope.class)) continue;
                hasScope = true;
                break;
            }
            if (!hasScope) {
                this.annotatedBeans.put(annotatedType.getJavaClass(), jakarta.enterprise.context.RequestScoped.class);
                pat.configureAnnotatedType().add((Annotation)RequestScoped.Literal.INSTANCE);
            }
        }
    }

    <T> void registerJerseyRequestScopedResources(@Observes @WithAnnotations(value={RequestScoped.class}) ProcessAnnotatedType<T> pat) {
        if (pat.getAnnotatedType().isAnnotationPresent(RequestScoped.class) && !pat.getAnnotatedType().isAnnotationPresent(jakarta.enterprise.context.RequestScoped.class)) {
            pat.configureAnnotatedType().remove(a -> RequestScoped.class.isInstance(a)).add((Annotation)RequestScoped.Literal.INSTANCE);
            this.annotatedBeans.put(pat.getAnnotatedType().getJavaClass(), jakarta.enterprise.context.RequestScoped.class);
        }
    }

    void processRegistrars(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        CdiInjectionManagerFactoryBase.setBeanManager(beanManager);
        this.processRegistrars();
    }

    void handleRequestScoped(@Observes @WithAnnotations(value={jakarta.enterprise.context.RequestScoped.class}) ProcessAnnotatedType<?> pat) {
        Class javaClass = pat.getAnnotatedType().getJavaClass();
        if (this.isJaxrs(javaClass) && this.isNotJerseyInternal(javaClass)) {
            pat.configureAnnotatedType().add((Annotation)CustomAnnotationLiteral.INSTANCE);
            this.annotatedBeans.put(javaClass, jakarta.enterprise.context.RequestScoped.class);
        }
    }

    <T> void handleApplicationScoped(@Observes @WithAnnotations(value={ApplicationScoped.class}) ProcessAnnotatedType<T> pat) {
        Class javaClass = pat.getAnnotatedType().getJavaClass();
        if (Application.class.isAssignableFrom(javaClass)) {
            pat.veto();
            this.applications.add(javaClass);
        } else if (this.isJaxrs(javaClass) && this.isNotJerseyInternal(javaClass)) {
            pat.configureAnnotatedType().add((Annotation)CustomAnnotationLiteral.INSTANCE);
            this.annotatedBeans.put(javaClass, ApplicationScoped.class);
        }
    }

    void handleDependent(@Observes @WithAnnotations(value={Dependent.class}) ProcessAnnotatedType<?> pat) {
        Class javaClass = pat.getAnnotatedType().getJavaClass();
        if (this.isJaxrs(javaClass) && this.isNotJerseyInternal(javaClass)) {
            pat.configureAnnotatedType().add((Annotation)CustomAnnotationLiteral.INSTANCE);
            this.annotatedBeans.put(javaClass, Dependent.class);
        }
    }

    void handleSessionScoped(@Observes @WithAnnotations(value={SessionScoped.class}) ProcessAnnotatedType<?> pat) {
        Class javaClass = pat.getAnnotatedType().getJavaClass();
        if (this.isJaxrs(javaClass) && this.isNotJerseyInternal(javaClass)) {
            pat.configureAnnotatedType().add((Annotation)CustomAnnotationLiteral.INSTANCE);
            this.annotatedBeans.put(javaClass, SessionScoped.class);
        }
    }

    void registerSingletonSubResources(@Observes @WithAnnotations(value={Singleton.class}) ProcessAnnotatedType<?> pat) {
        Class resourceClass = pat.getAnnotatedType().getJavaClass();
        if (resourceClass.getAnnotation(Path.class) != null) {
            this.annotatedBeans.put(resourceClass, Singleton.class);
        } else if (BeanHelper.isResourceClass(resourceClass)) {
            this.annotatedBeans.put(resourceClass, Singleton.class);
        }
    }

    void registerJerseyProviders(@Observes @WithAnnotations(value={Priority.class}) ProcessAnnotatedType<?> pat) {
        Class javaClass = pat.getAnnotatedType().getJavaClass();
        if (!this.isNotJerseyInternal(javaClass)) {
            pat.veto();
        }
        this.annotatedBeans.put(javaClass, Priority.class);
    }

    public <T> void observeInjectionTarget(@Observes ProcessInjectionTarget<T> pit) {
        if (!BeanInjectionTarget.class.isInstance(pit.getInjectionTarget())) {
            return;
        }
        BasicInjectionTarget it = (BasicInjectionTarget)pit.getInjectionTarget();
        JerseyInjectionTarget jerseyInjectionTarget = new JerseyInjectionTarget(it, pit.getAnnotatedType().getJavaClass());
        this.jerseyInjectionTargets.add(jerseyInjectionTarget);
        pit.setInjectionTarget(jerseyInjectionTarget);
    }

    void registerBeans(@Observes AfterBeanDiscovery abd, BeanManager beanManager) {
        this.serverInjectionManager.set((Object)new CdiInjectionManager(beanManager, this.mergedBindings, RuntimeType.SERVER));
        this.beanManagerSupplier = () -> beanManager;
        CdiInjectionManagerFactoryBase.setBeanManager(beanManager);
        this.registrationDone.set(true);
        List contextInjectionResolvers = this.serverBindings.getBindings().stream().filter(binding -> InjectionResolverBinding.class.isAssignableFrom(binding.getClass())).map(InjectionResolverBinding.class::cast).map(InjectionResolverBinding::getResolver).collect(Collectors.toList());
        this.injectionResolvers.addAll(contextInjectionResolvers);
        this.jerseyInjectionTargets.forEach(injectionTarget -> injectionTarget.setInjectionResolvers(this.injectionResolvers));
        this.registerBeans(RuntimeType.SERVER, this.serverBindings, abd, beanManager);
        this.registerBeans(RuntimeType.CLIENT, this.clientBindings, abd, beanManager);
        abd.addBean((Bean)new RequestScopeBean(beanManager));
        this.addAnnotatedBeans(abd, beanManager);
        this.serverBootstrapInjectionManager.setInjectionManager((InjectionManager)this.serverInjectionManager.get());
        ((CdiInjectionManager)this.serverInjectionManager.get()).managedBeans = this.managedBeans;
    }

    private void registerBeans(RuntimeType runtimeType, CachingBinder binder, AfterBeanDiscovery abd, BeanManager beanManager) {
        Collection<Binding> bindings = binder.getBindings();
        binder.setReadOnly();
        TreeMap<Long, InternalBinding> treeMap = new TreeMap<Long, InternalBinding>();
        for (InternalBinding internalBinding : bindings) {
            if (internalBinding.getId() == 0L || internalBinding.isForClient()) continue;
            if (treeMap.containsKey(internalBinding.getId())) {
                throw new IllegalStateException("Id " + internalBinding.getId() + " already exists:" + treeMap.get(internalBinding.getId()));
            }
            treeMap.put(internalBinding.getId(), internalBinding);
        }
        block1: for (InternalBinding internalBinding : bindings) {
            List preregistered;
            if (ClassBinding.class.isAssignableFrom(internalBinding.getClass())) {
                Object contract22;
                if (RuntimeType.CLIENT == runtimeType) {
                    for (Object contract22 : ((ClassBinding)internalBinding).getContracts()) {
                        preregistered = (List)this.classBindings.get(contract22);
                        if (preregistered == null || (preregistered = preregistered.stream().filter(pair -> pair.getBeans().get(0).getRutimeType() == RuntimeType.SERVER).collect(Collectors.toList())).size() != 1 && !internalBinding.isForClient()) continue;
                        BeanHelper.updateBean((ClassBinding)internalBinding, (BindingBeanPair)preregistered.get(0), this.injectionResolvers, beanManager);
                        continue block1;
                    }
                }
                BindingBeanPair pair2 = BeanHelper.registerBean(runtimeType, (ClassBinding)internalBinding, abd, this.injectionResolvers, beanManager);
                contract22 = ((ClassBinding)internalBinding).getContracts().iterator();
                while (contract22.hasNext()) {
                    Type contract3 = (Type)contract22.next();
                    this.classBindings.add((Object)contract3, (Object)pair2);
                }
                continue;
            }
            if (SupplierClassBinding.class.isAssignableFrom(internalBinding.getClass())) {
                BindingBeanPair pair2;
                if (RuntimeType.CLIENT == runtimeType) {
                    for (Type contract : ((SupplierClassBinding)internalBinding).getContracts()) {
                        preregistered = (List)this.supplierClassBindings.get((Object)contract);
                        if (preregistered == null || (preregistered = preregistered.stream().filter(pair -> pair.getBeans().get(0).getRutimeType() == RuntimeType.SERVER).collect(Collectors.toList())).size() != 1 && !internalBinding.isForClient()) continue;
                        BeanHelper.updateSupplierBean((SupplierClassBinding)internalBinding, (BindingBeanPair)preregistered.get(0), this.injectionResolvers, beanManager);
                        continue block1;
                    }
                }
                if ((pair2 = BeanHelper.registerSupplier(runtimeType, (SupplierClassBinding)internalBinding, abd, this.injectionResolvers, beanManager)) == null) continue;
                for (Type contract : ((SupplierClassBinding)internalBinding).getContracts()) {
                    this.supplierClassBindings.add((Object)contract, (Object)pair2);
                }
                continue;
            }
            if (InitializableInstanceBinding.class.isAssignableFrom(internalBinding.getClass())) {
                if (RuntimeType.SERVER == runtimeType || !internalBinding.isForClient() || !this.matchInitializableInstanceBinding((InitializableInstanceBinding)internalBinding)) {
                    this.initializableInstanceBindings.add((InitializableInstanceBinding)internalBinding);
                    BeanHelper.registerBean(runtimeType, (InitializableInstanceBinding)internalBinding, abd, this.injectionResolvers, beanManager);
                    continue;
                }
                this.skippedClientInstanceBindings.add((InitializableInstanceBinding)internalBinding);
                continue;
            }
            if (!InitializableSupplierInstanceBinding.class.isInstance(internalBinding)) continue;
            if (RuntimeType.SERVER == runtimeType || !internalBinding.isForClient() || !this.matchInitializableSupplierInstanceBinding((InitializableSupplierInstanceBinding)internalBinding)) {
                this.initializableSupplierInstanceBindings.add((InitializableSupplierInstanceBinding)internalBinding);
                BeanHelper.registerSupplier(runtimeType, (InitializableSupplierInstanceBinding)internalBinding, abd, beanManager);
                continue;
            }
            this.skippedClientSupplierInstanceBindings.add((InitializableSupplierInstanceBinding)internalBinding);
        }
    }

    private void addAnnotatedBeans(AfterBeanDiscovery abd, BeanManager beanManager) {
        for (Map.Entry<Class<?>, Class<Annotation>> contract : this.annotatedBeans.entrySet()) {
            Binding binding;
            Iterator<Binding> iterator = this.serverBindings.getBindings().iterator();
            while (!(!iterator.hasNext() || ClassBinding.class.isInstance(binding = iterator.next()) && ((ClassBinding)binding).getService() == contract.getClass() || InitializableInstanceBinding.class.isInstance(binding) && ((InitializableInstanceBinding)binding).getImplementationType() == contract.getClass())) {
            }
            if (!this.isNotJerseyInternal(contract.getKey())) continue;
            if (beanManager.getBeans((Type)contract.getKey(), new Annotation[0]).isEmpty()) {
                ClassBinding<?> binding2 = BinderRegisterExtension.bind(contract.getKey(), this.annotatedBeansBinder);
                if (Singleton.class.equals(contract.getValue())) {
                    binding2.in(Singleton.class);
                }
            }
            this.managedBeans.add(contract.getKey());
        }
        this.registerBeans(RuntimeType.SERVER, this.annotatedBeansBinder, abd, beanManager);
        this.serverBindings.getBindings().addAll(this.annotatedBeansBinder.getBindings());
    }

    private void registerApplicationHandler(BeanManager beanManager) {
        ResourceConfig resourceConfig = new ResourceConfig();
        for (Class<Application> applicationClass : this.applications) {
            this.bindApplication(applicationClass, resourceConfig, beanManager);
        }
        new ApplicationHandler((Application)resourceConfig);
    }

    private void bindApplication(Class<Application> applicationClass, ResourceConfig resourceConfig, BeanManager beanManager) {
        Application application = (Application)new Unmanaged(applicationClass).newInstance().produce().get();
        for (Class clazz : application.getClasses()) {
            if (beanManager.getBeans((Type)clazz, new Annotation[0]).isEmpty()) {
                resourceConfig.register(clazz);
                continue;
            }
            if (this.annotatedBeans.containsKey(clazz)) continue;
            this.annotatedBeans.put(clazz, Provider.class);
        }
        for (Object singleton : application.getSingletons()) {
            Class<?> clazz = singleton.getClass();
            if (beanManager.getBeans(clazz, new Annotation[0]).isEmpty()) {
                resourceConfig.register(singleton);
                continue;
            }
            if (this.annotatedBeans.containsKey(clazz)) continue;
            this.annotatedBeans.put(clazz, Provider.class);
        }
    }

    private static <T> ClassBinding<T> bind(Class<T> clazz, InternalBinder binder) {
        ClassBinding binding = binder.bindAsContract(clazz);
        return BinderRegisterExtension.toSuper(clazz, binding);
    }

    private static <T extends InternalBinding> T toSuper(Class<?> clazz, T binding) {
        Class<?> superClass = clazz;
        while (superClass != null) {
            if ((superClass = superClass.getSuperclass()) == null) continue;
            binding.to(superClass);
        }
        for (Class<?> intf : clazz.getInterfaces()) {
            binding.to(intf);
        }
        return binding;
    }

    private boolean isJaxrs(Class<?> clazz) {
        return Providers.isJaxRsProvider(clazz) || BeanHelper.isResourceClass(clazz) || this.isJerseyRegistrable(clazz);
    }

    private boolean isJerseyRegistrable(Class<?> clazz) {
        return Feature.class.isAssignableFrom(clazz) || DynamicFeature.class.isAssignableFrom(clazz);
    }

    private boolean isNotJerseyInternal(Class<?> clazz) {
        Package pkg = clazz.getPackage();
        if (pkg == null) {
            return false;
        }
        String pkgName = pkg.getName();
        return !pkgName.startsWith("org.glassfish.jersey") || pkgName.startsWith("org.glassfish.jersey.examples") || pkgName.startsWith("org.glassfish.jersey.tests");
    }

    private boolean matchInitializableInstanceBinding(InitializableInstanceBinding candidate) {
        for (InitializableInstanceBinding iib : this.initializableInstanceBindings) {
            if (!iib.matches(candidate).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean matchInitializableSupplierInstanceBinding(InitializableSupplierInstanceBinding candidate) {
        for (InitializableSupplierInstanceBinding isib : this.initializableSupplierInstanceBindings) {
            if (!isib.matches(candidate).matches()) continue;
            return true;
        }
        return false;
    }

    void register(BeforeBeanDiscovery beforeBeanDiscovery, Binding binding) {
        this.register(RuntimeType.SERVER, binding);
    }

    void register(BeforeBeanDiscovery beforeBeanDiscovery, Iterable<Binding> bindings) {
        this.register(RuntimeType.SERVER, bindings);
    }

    private void register(RuntimeType runtimeType, Binding binding) {
        CachingBinder bindings;
        CachingBinder cachingBinder = bindings = runtimeType == RuntimeType.CLIENT ? this.clientBindings : this.serverBindings;
        if (InstanceBinding.class.isInstance(binding)) {
            bindings.bind((Binding)InitializableInstanceBinding.from((InstanceBinding)binding, runtimeType));
        } else if (SupplierInstanceBinding.class.isInstance(binding)) {
            bindings.bind((Binding)InitializableSupplierInstanceBinding.from((SupplierInstanceBinding)binding, runtimeType));
        } else {
            bindings.bind(binding);
        }
    }

    private void register(RuntimeType runtimeType, Iterable<Binding> bindings) {
        for (Binding binding : bindings) {
            this.register(runtimeType, binding);
        }
    }

    private void processRegistrars() {
        LinkedList<BootstrapPreinitialization> registrars = new LinkedList<BootstrapPreinitialization>();
        for (BootstrapPreinitialization registrar : ServiceFinder.find(BootstrapPreinitialization.class)) {
            registrars.add(registrar);
        }
        for (BootstrapPreinitialization registrar : ServiceFinder.find(BootstrapPreinitialization.class)) {
            registrar.preregister(RuntimeType.SERVER, (InjectionManager)this.serverBootstrapInjectionManager);
        }
        for (BootstrapPreinitialization registrar : ServiceFinder.find(BootstrapPreinitialization.class)) {
            registrar.preregister(RuntimeType.CLIENT, (InjectionManager)this.clientBootstrapInjectionManager);
        }
    }

    InjectionManager getInjectionManager(RuntimeType runtimeType) {
        if (RuntimeType.CLIENT == runtimeType) {
            return this.registrationDone.get() ? new CdiClientInjectionManager(this.beanManagerSupplier.get(), this.mergedBindings) : this.clientBootstrapInjectionManager;
        }
        return this.registrationDone.get() ? (InjectionManager)this.serverInjectionManager.get() : this.serverBootstrapInjectionManager;
    }

    private class BootstrapInjectionManager
    implements InjectionManager {
        private final RuntimeType runtimeType;

        private BootstrapInjectionManager(RuntimeType runtimeType) {
            this.runtimeType = runtimeType;
        }

        public void completeRegistration() {
        }

        public void shutdown() {
        }

        public boolean isShutdown() {
            return false;
        }

        public void register(Binding binding) {
            BinderRegisterExtension.this.register(this.runtimeType, binding);
        }

        public void register(Iterable<Binding> descriptors) {
            for (Binding binding : descriptors) {
                this.register(binding);
            }
        }

        public void register(Binder binder) {
            this.register(binder.getBindings());
        }

        public void register(Object provider) throws IllegalArgumentException {
            throw new UnsupportedOperationException();
        }

        public boolean isRegistrable(Class<?> clazz) {
            return false;
        }

        public <T> T createAndInitialize(Class<T> createMe) {
            if (BinderRegisterExtension.this.isNotJerseyInternal(createMe)) {
                return null;
            }
            try {
                Constructor<T> constructor = createMe.getConstructor(new Class[0]);
                return constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                return null;
            }
        }

        public <T> T create(Class<T> createMe) {
            return this.createAndInitialize(createMe);
        }

        public <T> List<ServiceHolder<T>> getAllServiceHolders(Class<T> contractOrImpl, Annotation ... qualifiers) {
            return Collections.EMPTY_LIST;
        }

        public <T> T getInstance(Class<T> contractOrImpl, Annotation ... qualifiers) {
            return this.getInstance(contractOrImpl);
        }

        public <T> T getInstance(Class<T> contractOrImpl, String classAnalyzer) {
            return this.getInstance(contractOrImpl);
        }

        public <T> T getInstance(Class<T> contractOrImpl) {
            if (RequestScope.class == contractOrImpl) {
                return (T)((Object)new CdiRequestScope());
            }
            return null;
        }

        public <T> T getInstance(Type contractOrImpl) {
            return this.createAndInitialize((Class)contractOrImpl);
        }

        public Object getInstance(ForeignDescriptor foreignDescriptor) {
            throw new UnsupportedOperationException();
        }

        public ForeignDescriptor createForeignDescriptor(Binding binding) {
            throw new UnsupportedOperationException();
        }

        public <T> List<T> getAllInstances(Type contractOrImpl) {
            T t = this.getInstance(contractOrImpl);
            return t != null ? Collections.singletonList(t) : Collections.EMPTY_LIST;
        }

        public void inject(Object injectMe) {
        }

        public void inject(Object injectMe, String classAnalyzer) {
            throw new UnsupportedOperationException();
        }

        public void preDestroy(Object preDestroyMe) {
        }

        public RuntimeType getRuntimeType() {
            return this.runtimeType;
        }
    }

    private class CachingBinder
    extends InternalBinder {
        private final Ref<InjectionManager> injectionManager;
        private InternalBinder temporaryBinder = new TemporaryBinder();
        private final Collection<Binding> bindings = new LinkedList<Binding>();
        private final RuntimeType runtimeType;
        private boolean readOnly = false;

        private CachingBinder(Ref<InjectionManager> injectionManager, RuntimeType runtimeType) {
            this.injectionManager = injectionManager;
            this.runtimeType = runtimeType;
        }

        protected void configure() {
        }

        public <T> ClassBinding<T> bind(Class<T> serviceType) {
            return this.temporaryBinder.bind(serviceType);
        }

        public Binding bind(Binding binding) {
            return this.temporaryBinder.bind(binding);
        }

        public <T> ClassBinding<T> bindAsContract(GenericType<T> serviceType) {
            return this.temporaryBinder.bindAsContract(serviceType);
        }

        public <T> ClassBinding<T> bindAsContract(Class<T> serviceType) {
            return this.temporaryBinder.bindAsContract(serviceType);
        }

        public ClassBinding<Object> bindAsContract(Type serviceType) {
            return this.temporaryBinder.bindAsContract(serviceType);
        }

        public <T> InstanceBinding<T> bind(T service) {
            return this.temporaryBinder.bind(service);
        }

        public <T> SupplierClassBinding<T> bindFactory(Class<? extends Supplier<T>> supplierType, Class<? extends Annotation> supplierScope) {
            return this.temporaryBinder.bindFactory(supplierType, supplierScope);
        }

        public <T> SupplierClassBinding<T> bindFactory(Class<? extends Supplier<T>> supplierType) {
            return this.temporaryBinder.bindFactory(supplierType);
        }

        public <T> SupplierInstanceBinding<T> bindFactory(Supplier<T> factory) {
            return this.temporaryBinder.bindFactory(factory);
        }

        public <T extends InjectionResolver> InjectionResolverBinding<T> bind(T resolver) {
            return this.temporaryBinder.bind(resolver);
        }

        public Collection<Binding> getBindings() {
            if (!this.readOnly) {
                if (BinderRegisterExtension.this.registrationDone.get()) {
                    this.bindings.addAll(super.getBindings());
                }
                Collection newBindings = this.temporaryBinder.getBindings();
                for (Object binding : newBindings) {
                    if (InstanceBinding.class.isAssignableFrom(binding.getClass())) {
                        binding = InitializableInstanceBinding.from((InstanceBinding)binding, this.runtimeType);
                    } else if (SupplierInstanceBinding.class.isAssignableFrom(binding.getClass())) {
                        binding = InitializableSupplierInstanceBinding.from((SupplierInstanceBinding)binding, this.runtimeType);
                    }
                    this.bindings.add((Binding)binding);
                }
                this.temporaryBinder = new TemporaryBinder();
            }
            return this.bindings;
        }

        void setReadOnly() {
            this.readOnly = true;
        }

        private class TemporaryBinder
        extends InternalBinder {
            private TemporaryBinder() {
            }

            protected void configure() {
            }
        }
    }

    static class MergedBindings
    implements Binder {
        private final InternalBinder first;
        private final InternalBinder second;
        private final Collection<ClassBinding> classBindings = new ArrayList<ClassBinding>();
        private final Collection<InitializableInstanceBinding> instanceBindings = new ArrayList<InitializableInstanceBinding>();
        private final Collection<SupplierClassBinding> supplierClassBindings = new ArrayList<SupplierClassBinding>();
        private final Collection<InitializableSupplierInstanceBinding> supplierInstanceBindings = new ArrayList<InitializableSupplierInstanceBinding>();

        private MergedBindings(InternalBinder first, InternalBinder second) {
            this.first = first;
            this.second = second;
        }

        public Collection<? extends Binding> getServerBindings() {
            return this.first.getBindings();
        }

        public Collection<? extends Binding> getClientBindings() {
            return this.second.getBindings();
        }

        public Collection<Binding> getBindings() {
            final Collection firstBindings = this.first.getBindings();
            final Collection secondBindings = this.second.getBindings();
            Collection<Binding> merged = new Collection<Binding>(){

                @Override
                public int size() {
                    return firstBindings.size() + secondBindings.size();
                }

                @Override
                public boolean isEmpty() {
                    return firstBindings.isEmpty() && secondBindings.isEmpty();
                }

                @Override
                public boolean contains(Object o) {
                    return firstBindings.contains(o) || secondBindings.contains(o);
                }

                @Override
                public Iterator<Binding> iterator() {
                    final Iterator firstIterator = firstBindings.iterator();
                    final Iterator secondIterator = secondBindings.iterator();
                    return new Iterator<Binding>(){

                        @Override
                        public boolean hasNext() {
                            return firstIterator.hasNext() || secondIterator.hasNext();
                        }

                        @Override
                        public Binding next() {
                            return firstIterator.hasNext() ? (Binding)firstIterator.next() : (Binding)secondIterator.next();
                        }
                    };
                }

                @Override
                public Object[] toArray() {
                    Object[] array = new Object[this.size()];
                    Iterator<Binding> bindingIterator = this.iterator();
                    int i = 0;
                    while (bindingIterator.hasNext()) {
                        array[i++] = bindingIterator.next();
                    }
                    return array;
                }

                @Override
                public <T> T[] toArray(T[] a) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean add(Binding binding) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean remove(Object o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean containsAll(Collection<?> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean addAll(Collection<? extends Binding> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean retainAll(Collection<?> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void clear() {
                    throw new UnsupportedOperationException();
                }
            };
            return merged;
        }
    }
}

