/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.weld.internal.managed;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.ws.rs.RuntimeType;
import java.util.IdentityHashMap;
import java.util.Map;
import org.glassfish.jersey.inject.weld.internal.bean.ClassBean;
import org.glassfish.jersey.inject.weld.internal.bean.JerseyBean;
import org.glassfish.jersey.inject.weld.internal.bean.SupplierClassBean;
import org.glassfish.jersey.inject.weld.internal.inject.InitializableBinding;
import org.glassfish.jersey.inject.weld.internal.inject.InitializableInstanceBinding;
import org.glassfish.jersey.inject.weld.internal.inject.InitializableSupplierInstanceBinding;
import org.glassfish.jersey.inject.weld.internal.inject.MatchableBinding;
import org.glassfish.jersey.inject.weld.internal.injector.JerseyClientCreationalContext;
import org.glassfish.jersey.inject.weld.internal.injector.JerseyInjectionTarget;
import org.glassfish.jersey.inject.weld.internal.managed.BinderRegisterExtension;
import org.glassfish.jersey.inject.weld.internal.managed.CdiInjectionManager;
import org.glassfish.jersey.inject.weld.internal.managed.ContextSafe;
import org.glassfish.jersey.innate.inject.Bindings;
import org.glassfish.jersey.innate.inject.ClassBinding;
import org.glassfish.jersey.innate.inject.InstanceBinding;
import org.glassfish.jersey.innate.inject.SupplierClassBinding;
import org.glassfish.jersey.innate.inject.SupplierInstanceBinding;
import org.glassfish.jersey.internal.inject.Binding;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.jboss.weld.contexts.CreationalContextImpl;

public final class CdiClientInjectionManager
extends CdiInjectionManager {
    private Map<InitializableInstanceBinding, InitializableInstanceBinding> clientInstanceBindings = new IdentityHashMap<InitializableInstanceBinding, InitializableInstanceBinding>();
    private Map<InitializableSupplierInstanceBinding, InitializableSupplierInstanceBinding> clientSupplierInstanceBindings = new IdentityHashMap<InitializableSupplierInstanceBinding, InitializableSupplierInstanceBinding>();
    private Map<SupplierClassBinding, SupplierClassBinding> clientSupplierClassBinding = new IdentityHashMap<SupplierClassBinding, SupplierClassBinding>();
    private Map<ClassBinding, ClassBinding> clientClassBinding = new IdentityHashMap<ClassBinding, ClassBinding>();

    CdiClientInjectionManager(BeanManager beanManager, BinderRegisterExtension.MergedBindings bindings) {
        super(beanManager, bindings, RuntimeType.CLIENT);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void register(Binding binding) {
        if (InstanceBinding.class.isInstance(binding)) {
            MatchableBinding.Matching<InitializableInstanceBinding> matching = this.findPrebinding(InitializableInstanceBinding.class, binding);
            if (matching.matches()) {
                Object clone = matching.getBinding().clone();
                ((InitializableInstanceBinding)clone).init(((InstanceBinding)binding).getService());
                this.clientInstanceBindings.put(matching.getBinding(), (InitializableInstanceBinding)clone);
                return;
            }
            if (this.userBindings.init((InstanceBinding)binding)) return;
            throw new IllegalStateException("Not initialized " + ((InstanceBinding)binding).getService());
        }
        if (SupplierInstanceBinding.class.isInstance(binding)) {
            MatchableBinding.Matching<InitializableSupplierInstanceBinding> matching = this.findPrebinding(InitializableSupplierInstanceBinding.class, binding);
            if (!matching.matches()) throw new IllegalStateException("Not initialized " + ((SupplierInstanceBinding)binding).getSupplier());
            InitializableSupplierInstanceBinding clone = matching.getBinding().clone();
            clone.init(((SupplierInstanceBinding)binding).getSupplier());
            this.clientSupplierInstanceBindings.put(matching.getBinding(), clone);
            return;
        }
        if (!ClassBinding.class.isInstance(binding)) return;
        ClassBinding prebinding = this.findClassBinding(binding.getImplementationType());
        if (prebinding != null) return;
        if (!this.userBindings.init((ClassBinding)binding)) {
            throw new IllegalStateException("Unexpected");
        }
        this.clientClassBinding.put(prebinding, (ClassBinding)binding);
    }

    public InitializableInstanceBinding getInjectionManagerBinding(InitializableInstanceBinding binding) {
        InitializableInstanceBinding clientBinding = this.clientInstanceBindings.get(binding);
        return clientBinding != null ? clientBinding : binding;
    }

    public InitializableSupplierInstanceBinding getInjectionManagerBinding(InitializableSupplierInstanceBinding binding) {
        InitializableSupplierInstanceBinding clientBinding = this.clientSupplierInstanceBindings.get(binding);
        return clientBinding != null ? clientBinding : binding;
    }

    public SupplierClassBinding getInjectionManagerBinding(SupplierClassBinding binding) {
        SupplierClassBinding clientBinding = this.clientSupplierClassBinding.get(binding);
        return clientBinding != null ? clientBinding : binding;
    }

    public ClassBinding getInjectionManagerBinding(ClassBinding binding) {
        ClassBinding clientBinding = this.clientClassBinding.get(binding);
        return clientBinding != null ? clientBinding : binding;
    }

    @Override
    protected void lockContext() {
        ContextSafe.lockContext(this);
    }

    @Override
    protected void unlockContext() {
        ContextSafe.unlock(this);
    }

    @Override
    public void shutdown() {
        this.clientInstanceBindings.clear();
    }

    @Override
    protected <T> CreationalContext<T> createCreationalContext(Bean<T> bean) {
        JerseyClientCreationalContext ctx = new JerseyClientCreationalContext((CreationalContextImpl)super.createCreationalContext(bean)).setInjectionManager(this);
        return ctx;
    }

    @Override
    public void completeRegistration() throws IllegalStateException {
        this.register(Bindings.service((Object)this).to(InjectionManager.class));
    }

    @Override
    protected boolean isRuntimeTypeBean(Bean<?> bean) {
        return !JerseyBean.class.isInstance(bean) || ((JerseyBean)bean).getRutimeType() == RuntimeType.CLIENT || this.clientInstanceBindings.containsKey(((JerseyBean)bean).getBinding()) || this.clientSupplierInstanceBindings.containsKey(((JerseyBean)bean).getBinding()) || CdiClientInjectionManager.isTwoFoldInstantiator((JerseyBean)bean);
    }

    private static boolean isTwoFoldInstantiator(JerseyBean bean) {
        Object injectionTarget = null;
        if (ClassBean.class.isInstance(bean)) {
            injectionTarget = ((ClassBean)bean).getInjectionTarget();
        } else if (SupplierClassBean.class.isInstance(bean)) {
            injectionTarget = ((SupplierClassBean)bean).getInjectionTarget();
        }
        if (injectionTarget != null && JerseyInjectionTarget.class.isInstance(injectionTarget)) {
            JerseyInjectionTarget jerseyInjectionTarget = (JerseyInjectionTarget)((Object)injectionTarget);
            return jerseyInjectionTarget.getTwofoldInstantiator().hasOptionalConstructorInjectionPoint();
        }
        return false;
    }

    private boolean isInit(JerseyBean bean) {
        if (InitializableBinding.class.isInstance(bean.getBinding())) {
            return ((InitializableBinding)bean.getBinding()).isInit();
        }
        return true;
    }

    @Override
    public RuntimeType getRuntimeType() {
        return RuntimeType.CLIENT;
    }
}

