/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.weld.internal.managed;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.enterprise.inject.spi.InjectionTargetFactory;
import jakarta.enterprise.inject.spi.Unmanaged;
import jakarta.inject.Singleton;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.core.Context;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.glassfish.jersey.inject.weld.internal.bean.JerseyBean;
import org.glassfish.jersey.inject.weld.internal.inject.InitializableInstanceBinding;
import org.glassfish.jersey.inject.weld.internal.inject.InitializableSupplierInstanceBinding;
import org.glassfish.jersey.inject.weld.internal.inject.MatchableBinding;
import org.glassfish.jersey.inject.weld.internal.managed.BinderRegisterExtension;
import org.glassfish.jersey.inject.weld.internal.managed.LocalizationMessages;
import org.glassfish.jersey.inject.weld.internal.managed.ProviderBindings;
import org.glassfish.jersey.inject.weld.managed.CdiInjectionManagerFactory;
import org.glassfish.jersey.innate.inject.Bindings;
import org.glassfish.jersey.innate.inject.ClassBinding;
import org.glassfish.jersey.innate.inject.InstanceBinding;
import org.glassfish.jersey.innate.inject.InternalBinding;
import org.glassfish.jersey.innate.inject.SupplierClassBinding;
import org.glassfish.jersey.innate.inject.SupplierInstanceBinding;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.Binding;
import org.glassfish.jersey.internal.inject.ForeignDescriptor;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.ServiceHolder;
import org.glassfish.jersey.internal.inject.ServiceHolderImpl;
import org.glassfish.jersey.internal.util.ReflectionHelper;

@Singleton
class CdiInjectionManager
implements InjectionManager {
    private final BeanManager beanManager;
    private final BinderRegisterExtension.MergedBindings bindings;
    private boolean isCompleted = false;
    Set<Class<?>> managedBeans;
    protected final ProviderBindings userBindings;

    CdiInjectionManager(BeanManager beanManager, BinderRegisterExtension.MergedBindings bindings, RuntimeType runtimeType) {
        this.beanManager = beanManager;
        this.bindings = bindings;
        this.userBindings = new ProviderBindings(runtimeType, this);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void register(Binding binding) {
        if (this.isManagedClass(binding)) {
            return;
        }
        if (InstanceBinding.class.isInstance(binding)) {
            MatchableBinding.Matching<InitializableInstanceBinding> matching = this.findPrebinding(InitializableInstanceBinding.class, binding);
            if (matching.matches()) {
                matching.getBinding().init(((InstanceBinding)binding).getService());
                return;
            }
            if (this.userBindings.init((InstanceBinding)binding)) return;
            throw new IllegalStateException("Could not initialize " + ((InstanceBinding)binding).getService());
        }
        if (SupplierInstanceBinding.class.isInstance(binding)) {
            MatchableBinding.Matching<InitializableSupplierInstanceBinding> matching = this.findPrebinding(InitializableSupplierInstanceBinding.class, binding);
            if (!matching.matches()) throw new IllegalStateException("Not initialized " + ((SupplierInstanceBinding)binding).getSupplier());
            matching.getBinding().init(((SupplierInstanceBinding)binding).getSupplier());
            return;
        }
        if (!ClassBinding.class.isInstance(binding)) return;
        if (this.findClassBinding(binding.getImplementationType()) != null) return;
        if (this.userBindings.init((ClassBinding)binding)) return;
        throw new IllegalStateException("ClassBinding for " + binding.getImplementationType() + " not preregistered");
    }

    protected <MB extends MatchableBinding> MatchableBinding.Matching<MB> findPrebinding(Class<MB> matchebleBindingClass, Binding binderBinding) {
        Binding preBinding;
        Collection<Binding> preBindings = this.bindings.getBindings();
        MatchableBinding.Matching matching = MatchableBinding.Matching.noneMatching();
        Iterator<Binding> iterator = preBindings.iterator();
        while (!(!iterator.hasNext() || matchebleBindingClass.isInstance(preBinding = iterator.next()) && ((matching = matching.better(((MatchableBinding)preBinding).matching((InternalBinding)binderBinding))).isBest() || matching.matches() && ((InternalBinding)binderBinding).isForClient()))) {
        }
        return matching;
    }

    protected <T> ClassBinding<T> findClassBinding(Class<T> implementationType) {
        Collection<Binding> preBindings = this.bindings.getBindings();
        for (Binding preBinding : preBindings) {
            if (!ClassBinding.class.isInstance(preBinding) || !((ClassBinding)preBinding).getImplementationType().equals(implementationType)) continue;
            return (ClassBinding)preBinding;
        }
        return null;
    }

    protected <T> SupplierClassBinding<T> findSupplierClassBinding(Class<T> implementationType) {
        Collection<Binding> preBindings = this.bindings.getBindings();
        for (Binding preBinding : preBindings) {
            if (!SupplierClassBinding.class.isInstance(preBinding) || !((SupplierClassBinding)preBinding).getImplementationType().equals(implementationType)) continue;
            return (SupplierClassBinding)preBinding;
        }
        return null;
    }

    private boolean isManagedClass(Binding binding) {
        return this.managedBeans != null && binding.getImplementationType() != null && (this.managedBeans.contains(binding.getImplementationType()) || this.managedBeans.contains(binding.getImplementationType().getSuperclass()));
    }

    public void register(Iterable<Binding> bindings) {
        for (Binding binding : bindings) {
            this.register(binding);
        }
    }

    public void register(Binder binder) {
        for (Binding binding : Bindings.getBindings((InjectionManager)this, (Binder)binder)) {
            this.register(binding);
        }
    }

    public void register(Object provider) throws IllegalArgumentException {
        throw new IllegalArgumentException(LocalizationMessages.CDI_2_PROVIDER_NOT_REGISTRABLE(provider.getClass()));
    }

    public boolean isRegistrable(Class<?> clazz) {
        return false;
    }

    public <T> T create(Class<T> createMe) {
        Unmanaged.UnmanagedInstance unmanaged = new Unmanaged(this.beanManager, createMe).newInstance();
        return (T)unmanaged.produce().get();
    }

    public <T> T createAndInitialize(Class<T> createMe) {
        Unmanaged.UnmanagedInstance unmanaged = new Unmanaged(this.beanManager, createMe).newInstance();
        try {
            this.lockContext();
            unmanaged = unmanaged.produce().inject();
            this.injectContext(unmanaged.get());
        }
        finally {
            this.unlockContext();
        }
        return (T)unmanaged.postConstruct().get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<ServiceHolder<T>> getAllServiceHolders(Class<T> contractOrImpl, Annotation ... qualifiers) {
        ArrayList<ServiceHolder<T>> result = new ArrayList<ServiceHolder<T>>();
        for (Bean bean : this.beanManager.getBeans(contractOrImpl, qualifiers)) {
            Object reference;
            if (!this.isRuntimeTypeBean(bean)) continue;
            CreationalContext<T> ctx = this.createCreationalContext(bean);
            try {
                this.lockContext();
                reference = this.beanManager.getReference(bean, contractOrImpl, ctx);
            }
            finally {
                this.unlockContext();
            }
            int rank = 0;
            if (bean instanceof JerseyBean) {
                rank = ((JerseyBean)bean).getRank();
            }
            result.add((ServiceHolder<T>)new ServiceHolderImpl(reference, bean.getBeanClass(), bean.getTypes(), rank));
        }
        result.addAll(this.userBindings.getServiceHolders(contractOrImpl));
        return result;
    }

    public <T> T getInstance(Class<T> contractOrImpl, Annotation ... qualifiers) {
        return this.getInstanceInternal(contractOrImpl, qualifiers);
    }

    public <T> T getInstance(Class<T> contractOrImpl) {
        return this.getInstanceInternal(contractOrImpl, new Annotation[0]);
    }

    public <T> T getInstance(Type contractOrImpl) {
        return this.getInstanceInternal(contractOrImpl, new Annotation[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T getInstanceInternal(Type contractOrImpl, Annotation ... qualifiers) {
        Object t;
        Set beans = this.beanManager.getBeans(contractOrImpl, qualifiers);
        if (beans.isEmpty()) {
            return null;
        }
        Iterator beansIterator = beans.iterator();
        Bean bean = (Bean)beansIterator.next();
        boolean isRuntimeType = false;
        while (!(isRuntimeType = this.isRuntimeTypeBean(bean)) && beansIterator.hasNext()) {
            bean = (Bean)beansIterator.next();
        }
        if (!isRuntimeType) {
            throw new IllegalStateException("Bean for type " + contractOrImpl + " not found");
        }
        CreationalContext<T> ctx = this.createCreationalContext(bean);
        try {
            this.lockContext();
            t = this.beanManager.getReference(bean, contractOrImpl, ctx);
        }
        finally {
            this.unlockContext();
        }
        return (T)t;
    }

    public Object getInstance(ForeignDescriptor foreignDescriptor) {
        Bean bean = (Bean)foreignDescriptor.get();
        CreationalContext ctx = this.createCreationalContext(bean);
        return bean.create(ctx);
    }

    public ForeignDescriptor createForeignDescriptor(Binding binding) {
        Class<?> clazz;
        if (ClassBinding.class.isAssignableFrom(binding.getClass())) {
            clazz = ((ClassBinding)binding).getService();
        } else if (InstanceBinding.class.isAssignableFrom(binding.getClass())) {
            clazz = ((InstanceBinding)binding).getService().getClass();
        } else {
            throw new RuntimeException(org.glassfish.jersey.internal.LocalizationMessages.UNKNOWN_DESCRIPTOR_TYPE((Object)binding.getClass().getSimpleName()));
        }
        Set beans = this.beanManager.getBeans(clazz, new Annotation[0]);
        if (beans.isEmpty()) {
            return null;
        }
        Bean bean = (Bean)beans.iterator().next();
        CreationalContext ctx = this.createCreationalContext(bean);
        return ForeignDescriptor.wrap((Object)bean, instance -> bean.destroy(instance, ctx));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> getAllInstances(Type contractOrImpl) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Bean bean : this.beanManager.getBeans(contractOrImpl, new Annotation[0])) {
            Object reference;
            if (!this.isRuntimeTypeBean(bean)) continue;
            CreationalContext<T> ctx = this.createCreationalContext(bean);
            try {
                this.lockContext();
                reference = this.beanManager.getReference(bean, contractOrImpl, ctx);
            }
            finally {
                this.unlockContext();
            }
            result.add(reference);
        }
        result.addAll(this.userBindings.getServices(contractOrImpl));
        return result;
    }

    public void inject(Object instance) {
        CreationalContext creationalContext = this.createCreationalContext(null);
        AnnotatedType annotatedType = this.beanManager.createAnnotatedType(instance.getClass());
        InjectionTargetFactory injectionTargetFactory = this.beanManager.getInjectionTargetFactory(annotatedType);
        InjectionTarget injectionTarget = injectionTargetFactory.createInjectionTarget(null);
        injectionTarget.inject(instance, creationalContext);
        if (CdiInjectionManagerFactory.SUPPORT_CONTEXT) {
            this.injectContext(instance);
        }
    }

    public void injectContext(Object instance) {
        Field[] fields;
        for (Field f : fields = (Field[])AccessController.doPrivileged(ReflectionHelper.getAllFieldsPA(instance.getClass()))) {
            if (!f.isAnnotationPresent(Context.class)) continue;
            CdiInjectionManager.setAccesible(f);
            try {
                if (f.get(instance) != null) continue;
                Object o = this.getInstance(f.getType());
                f.set(instance, o);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void setAccesible(Field member) {
        if (CdiInjectionManager.isPublic(member)) {
            return;
        }
        AccessController.doPrivileged(() -> {
            member.setAccessible(true);
            return null;
        });
    }

    private static boolean isPublic(Member member) {
        return Modifier.isPublic(member.getModifiers());
    }

    protected void lockContext() {
    }

    protected void unlockContext() {
    }

    public void preDestroy(Object preDestroyMe) {
    }

    public void completeRegistration() throws IllegalStateException {
        if (!this.isCompleted) {
            this.register(Bindings.service((Object)this).to(InjectionManager.class));
            this.isCompleted = false;
        }
    }

    public void shutdown() {
    }

    public boolean isShutdown() {
        return false;
    }

    protected BinderRegisterExtension.MergedBindings getBindings() {
        return this.bindings;
    }

    protected BeanManager getBeanManager() {
        return this.beanManager;
    }

    protected <T> CreationalContext<T> createCreationalContext(Bean<T> bean) {
        return this.beanManager.createCreationalContext(bean);
    }

    protected boolean isRuntimeTypeBean(Bean<?> bean) {
        return !JerseyBean.class.isInstance(bean) || ((JerseyBean)bean).getRutimeType() == RuntimeType.SERVER;
    }

    public void inject(Object injectMe, String classAnalyzer) {
        if ("CONTEXT".equals(classAnalyzer)) {
            this.injectContext(injectMe);
            return;
        }
        throw new UnsupportedOperationException();
    }

    public <T> T getInstance(Class<T> contractOrImpl, String classAnalyzer) {
        throw new UnsupportedOperationException();
    }

    public RuntimeType getRuntimeType() {
        return RuntimeType.SERVER;
    }
}

