/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.weld.internal.managed;

import jakarta.ws.rs.Path;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.client.RxInvokerProvider;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.WriterInterceptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.jersey.inject.weld.internal.inject.ClassListBinding;
import org.glassfish.jersey.inject.weld.internal.inject.InstanceListBinding;
import org.glassfish.jersey.innate.inject.ClassBinding;
import org.glassfish.jersey.innate.inject.InstanceBinding;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.ServiceHolder;
import org.glassfish.jersey.internal.util.collection.Cache;
import org.glassfish.jersey.server.model.Resource;

class ProviderBindings {
    private final Map<Type, InstanceListBinding<?>> userInstanceBindings = new HashMap();
    private final Map<Type, ClassListBinding<?>> userClassBindings = new HashMap();
    private final Map<Type, ClassListBinding<?>> userPathBindings = new HashMap();
    private final InjectionManager injectionManager;
    private final Cache<Class<?>, Boolean> jaxRsResourceCache = new Cache(clazz -> Resource.from((Class)clazz, (boolean)true) != null && Resource.from((Class)clazz) != null);

    public boolean isJaxRsResource(Class<?> resource) {
        return (Boolean)this.jaxRsResourceCache.apply(resource);
    }

    ProviderBindings(RuntimeType runtimeType, InjectionManager injectionManager) {
        this.injectionManager = injectionManager;
        if (runtimeType == RuntimeType.CLIENT) {
            this.init(ClientRequestFilter.class);
            this.init(ClientResponseFilter.class);
            this.init(RxInvokerProvider.class);
        } else if (runtimeType == RuntimeType.SERVER) {
            this.init(ContainerResponseFilter.class);
            this.init(ContainerRequestFilter.class);
            this.init(DynamicFeature.class);
        }
        this.init(ParamConverterProvider.class);
        this.init(WriterInterceptor.class);
        this.init(ReaderInterceptor.class);
        this.init(MessageBodyReader.class);
        this.init(MessageBodyWriter.class);
    }

    private <T> void init(Class<T> contract) {
        this.userInstanceBindings.put(contract, new InstanceListBinding<T>(contract));
        this.userClassBindings.put(contract, new ClassListBinding<T>(contract, this.injectionManager));
    }

    boolean init(InstanceBinding<?> userBinding) {
        boolean init = false;
        for (Type contract : userBinding.getContracts()) {
            InstanceListBinding<?> binding = this.userInstanceBindings.get(contract);
            if (binding == null) continue;
            init = true;
            binding.init(userBinding);
        }
        return init;
    }

    boolean init(ClassBinding<?> userBinding) {
        boolean init = false;
        for (Type contract : userBinding.getContracts()) {
            ClassListBinding<?> binding = this.userClassBindings.get(contract);
            if (binding == null) continue;
            init = true;
            binding.init(userBinding);
        }
        if (!init) {
            init = this.initPathBinding(userBinding);
        }
        return init;
    }

    private boolean initPathBinding(ClassBinding<?> userBinding) {
        boolean init = false;
        if (this.isJaxRsResource(userBinding.getService())) {
            for (Type contract : userBinding.getContracts()) {
                if (!this.isClass(contract)) continue;
                ClassListBinding<?> binding = this.userPathBindings.get(contract);
                if (binding != null) {
                    binding.init(userBinding);
                } else {
                    this.userPathBindings.put(contract, new ClassListBinding((Class)contract, this.injectionManager));
                }
                init = true;
            }
        }
        return init;
    }

    <T> List<ServiceHolder<T>> getServiceHolders(Type contract) {
        ClassListBinding<?> classBinding;
        ArrayList<ServiceHolder<T>> list = new ArrayList<ServiceHolder<T>>();
        InstanceListBinding<?> instanceBinding = this.userInstanceBindings.get(contract);
        if (instanceBinding != null) {
            list.addAll(instanceBinding.getServiceHolders());
        }
        if ((classBinding = this.userClassBindings.get(contract)) != null) {
            list.addAll(classBinding.getServiceHolders());
        } else if (this.isAnnotationPresent(contract, Path.class)) {
            classBinding = this.userPathBindings.get(contract);
            list.addAll(classBinding.getServiceHolders());
        }
        return list;
    }

    <T> List<T> getServices(Type contract) {
        ClassListBinding<?> classBinding;
        ArrayList list = new ArrayList();
        InstanceListBinding<?> instanceBinding = this.userInstanceBindings.get(contract);
        if (instanceBinding != null) {
            list.addAll(instanceBinding.getServices());
        }
        if ((classBinding = this.userClassBindings.get(contract)) != null) {
            list.addAll(classBinding.getServices());
        } else if (this.isAnnotationPresent(contract, Path.class)) {
            classBinding = this.userPathBindings.get(contract);
            list.addAll(classBinding.getServices());
        }
        return list;
    }

    private boolean isAnnotationPresent(Type contract, Class<? extends Annotation> annotation) {
        return this.isClass(contract) && ((Class)contract).isAnnotationPresent(annotation);
    }

    private boolean isClass(Type contract) {
        return Class.class.isInstance(contract);
    }
}

