/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jdk.connector;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.glassfish.jersey.jdk.connector.BodyOutputStream;
import org.glassfish.jersey.jdk.connector.LocalizationMessages;
import org.glassfish.jersey.jdk.connector.WriteListener;

class BufferedBodyOutputStream
extends BodyOutputStream {
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private volatile Mode mode = Mode.UNDECIDED;

    BufferedBodyOutputStream() {
    }

    @Override
    public void setWriteListener(WriteListener writeListener) {
        if (this.mode == Mode.ASYNCHRONOUS) {
            throw new IllegalStateException(LocalizationMessages.WRITE_LISTENER_SET_ONLY_ONCE());
        }
        if (this.mode == Mode.SYNCHRONOUS) {
            throw new UnsupportedOperationException(LocalizationMessages.ASYNC_OPERATION_NOT_SUPPORTED());
        }
        this.mode = Mode.ASYNCHRONOUS;
        try {
            writeListener.onWritePossible();
        }
        catch (IOException e) {
            writeListener.onError(e);
        }
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.mode == Mode.UNDECIDED) {
            this.mode = Mode.SYNCHRONOUS;
        }
        this.buffer.write(b);
    }

    ByteBuffer toBuffer() {
        return ByteBuffer.wrap(this.buffer.toByteArray());
    }

    private static enum Mode {
        UNDECIDED,
        ASYNCHRONOUS,
        SYNCHRONOUS;

    }
}

