/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jdk.connector;

import java.net.CookiePolicy;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.SslConfigurator;
import org.glassfish.jersey.client.ClientProperties;
import org.glassfish.jersey.jdk.connector.JdkConnectorProvider;
import org.glassfish.jersey.jdk.connector.LocalizationMessages;
import org.glassfish.jersey.jdk.connector.ThreadPoolConfig;

class ConnectorConfiguration {
    private static final Logger LOGGER = Logger.getLogger(ConnectorConfiguration.class.getName());
    private final int chunkSize;
    private final boolean followRedirects;
    private final int maxRedirects;
    private final ThreadPoolConfig threadPoolConfig;
    private final int containerIdleTimeout;
    private final int maxHeaderSize;
    private final CookiePolicy cookiePolicy;
    private final int maxConnectionsPerDestination;
    private final int connectionIdleTimeout;
    private final SSLContext sslContext;
    private final HostnameVerifier hostnameVerifier;
    private final int responseTimeout;
    private final int connectTimeout;
    private final ProxyConfiguration proxyConfiguration;

    ConnectorConfiguration(Client client, Configuration config) {
        Map properties = config.getProperties();
        int proposedChunkSize = (Integer)ClientProperties.getValue((Map)properties, (String)"jersey.config.client.chunkedEncodingSize", (Object)4096, Integer.class);
        if (proposedChunkSize < 0) {
            LOGGER.warning(LocalizationMessages.NEGATIVE_CHUNK_SIZE(proposedChunkSize, 4096));
            proposedChunkSize = 4096;
        }
        this.chunkSize = proposedChunkSize;
        this.threadPoolConfig = (ThreadPoolConfig)ClientProperties.getValue((Map)properties, (String)"jersey.config.client.JdkConnectorProvider.workerThreadPoolConfig", (Object)ThreadPoolConfig.defaultConfig(), ThreadPoolConfig.class);
        this.threadPoolConfig.setCorePoolSize((Integer)ClientProperties.getValue((Map)properties, (String)"jersey.config.client.async.threadPoolSize", (Object)this.threadPoolConfig.getCorePoolSize(), Integer.class));
        this.containerIdleTimeout = (Integer)ClientProperties.getValue((Map)properties, (String)"jersey.config.client.JdkConnectorProvider.containerIdleTimeout", (Object)30000, Integer.class);
        this.maxHeaderSize = (Integer)ClientProperties.getValue((Map)properties, (String)"jersey.config.client.JdkConnectorProvider.maxHeaderSize", (Object)8192, Integer.class);
        this.followRedirects = (Boolean)ClientProperties.getValue((Map)properties, (String)"jersey.config.client.followRedirects", (Object)true, Boolean.class);
        this.cookiePolicy = (CookiePolicy)ClientProperties.getValue((Map)properties, (String)"jersey.config.client.JdkConnectorProvider.cookiePolicy", (Object)JdkConnectorProvider.DEFAULT_COOKIE_POLICY, CookiePolicy.class);
        this.maxRedirects = (Integer)ClientProperties.getValue((Map)properties, (String)"jersey.config.client.JdkConnectorProvider.maxRedirects", (Object)5, Integer.class);
        this.maxConnectionsPerDestination = (Integer)ClientProperties.getValue((Map)properties, (String)"jersey.config.client.JdkConnectorProvider.maxConnectionsPerDestination", (Object)20, Integer.class);
        this.connectionIdleTimeout = (Integer)ClientProperties.getValue((Map)properties, (String)"jersey.config.client.JdkConnectorProvider.connectionIdleTimeout", (Object)1000000, Integer.class);
        this.responseTimeout = (Integer)ClientProperties.getValue((Map)properties, (String)"jersey.config.client.readTimeout", (Object)0, Integer.class);
        this.connectTimeout = (Integer)ClientProperties.getValue((Map)properties, (String)"jersey.config.client.connectTimeout", (Object)0, Integer.class);
        this.sslContext = client.getSslContext() == null ? SslConfigurator.getDefaultContext() : client.getSslContext();
        this.hostnameVerifier = client.getHostnameVerifier();
        this.proxyConfiguration = new ProxyConfiguration(properties);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, LocalizationMessages.CONNECTOR_CONFIGURATION(this.toString()));
        }
    }

    int getChunkSize() {
        return this.chunkSize;
    }

    boolean getFollowRedirects() {
        return this.followRedirects;
    }

    int getMaxRedirects() {
        return this.maxRedirects;
    }

    ThreadPoolConfig getThreadPoolConfig() {
        return this.threadPoolConfig;
    }

    int getContainerIdleTimeout() {
        return this.containerIdleTimeout;
    }

    int getMaxHeaderSize() {
        return this.maxHeaderSize;
    }

    CookiePolicy getCookiePolicy() {
        return this.cookiePolicy;
    }

    int getMaxConnectionsPerDestination() {
        return this.maxConnectionsPerDestination;
    }

    int getConnectionIdleTimeout() {
        return this.connectionIdleTimeout;
    }

    SSLContext getSslContext() {
        return this.sslContext;
    }

    HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    int getResponseTimeout() {
        return this.responseTimeout;
    }

    int getConnectTimeout() {
        return this.connectTimeout;
    }

    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }

    public String toString() {
        return "ConnectorConfiguration{, chunkSize=" + this.chunkSize + ", followRedirects=" + this.followRedirects + ", maxRedirects=" + this.maxRedirects + ", threadPoolConfig=" + this.threadPoolConfig + ", containerIdleTimeout=" + this.containerIdleTimeout + ", maxHeaderSize=" + this.maxHeaderSize + ", cookiePolicy=" + this.cookiePolicy + ", maxConnectionsPerDestination=" + this.maxConnectionsPerDestination + ", connectionIdleTimeout=" + this.connectionIdleTimeout + ", sslContext=" + this.sslContext + ", hostnameVerifier=" + this.hostnameVerifier + ", responseTimeout=" + this.responseTimeout + ", connectTimeout=" + this.connectTimeout + ", proxyConfiguration=" + this.proxyConfiguration.toString() + '}';
    }

    static class ProxyConfiguration {
        private final boolean configured;
        private final String host;
        private final int port;
        private final String userName;
        private final String password;

        private ProxyConfiguration(Map<String, Object> properties) {
            String uriStr = (String)ClientProperties.getValue(properties, (String)"jersey.config.client.proxy.uri", String.class);
            if (uriStr == null) {
                this.configured = false;
                this.host = null;
                this.port = -1;
                this.userName = null;
                this.password = null;
                return;
            }
            this.configured = true;
            URI proxyUri = URI.create(uriStr);
            this.host = proxyUri.getHost();
            this.port = proxyUri.getPort() == -1 ? 8080 : proxyUri.getPort();
            this.userName = (String)ClientProperties.getValue(properties, (String)"jersey.config.client.proxy.username", String.class);
            this.password = (String)ClientProperties.getValue(properties, (String)"jersey.config.client.proxy.password", String.class);
        }

        boolean isConfigured() {
            return this.configured;
        }

        String getHost() {
            return this.host;
        }

        int getPort() {
            return this.port;
        }

        String getUserName() {
            return this.userName;
        }

        String getPassword() {
            return this.password;
        }
    }
}

