/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jdk.connector;

import java.net.URI;
import java.nio.ByteBuffer;
import org.glassfish.jersey.jdk.connector.ChunkedBodyOutputStream;
import org.glassfish.jersey.jdk.connector.CompletionHandler;
import org.glassfish.jersey.jdk.connector.Constants;
import org.glassfish.jersey.jdk.connector.Filter;
import org.glassfish.jersey.jdk.connector.HttpParser;
import org.glassfish.jersey.jdk.connector.HttpRequest;
import org.glassfish.jersey.jdk.connector.HttpRequestEncoder;
import org.glassfish.jersey.jdk.connector.HttpResponse;
import org.glassfish.jersey.jdk.connector.ParseException;
import org.glassfish.jersey.jdk.connector.Utils;

class HttpFilter
extends Filter<HttpRequest, HttpResponse, ByteBuffer, ByteBuffer> {
    private final HttpParser httpParser;

    HttpFilter(Filter<ByteBuffer, ByteBuffer, ?, ?> downstreamFilter, int maxHeaderSize, int maxBufferSize) {
        super(downstreamFilter);
        this.httpParser = new HttpParser(maxHeaderSize, maxBufferSize);
    }

    @Override
    void write(final HttpRequest httpRequest, final CompletionHandler<HttpRequest> completionHandler) {
        this.addTransportHeaders(httpRequest);
        ByteBuffer header = HttpRequestEncoder.encodeHeader(httpRequest);
        this.prepareForReply(httpRequest, completionHandler);
        this.downstreamFilter.write(header, new CompletionHandler<ByteBuffer>(){

            @Override
            public void failed(Throwable throwable) {
                completionHandler.failed(throwable);
            }

            @Override
            public void completed(ByteBuffer result) {
                HttpFilter.this.writeBody(httpRequest, completionHandler);
            }
        });
    }

    private void writeBody(HttpRequest httpRequest, final CompletionHandler<HttpRequest> completionHandler) {
        switch (httpRequest.getBodyMode()) {
            case CHUNKED: {
                ChunkedBodyOutputStream bodyStream = (ChunkedBodyOutputStream)httpRequest.getBodyStream();
                bodyStream.open(this.downstreamFilter);
                break;
            }
            case BUFFERED: {
                ByteBuffer body = httpRequest.getBufferedBody();
                this.downstreamFilter.write(body, new CompletionHandler<ByteBuffer>(){

                    @Override
                    public void failed(Throwable throwable) {
                        completionHandler.failed(throwable);
                    }
                });
                break;
            }
        }
    }

    private void prepareForReply(HttpRequest httpRequest, CompletionHandler<HttpRequest> completionHandler) {
        completionHandler.completed(httpRequest);
        boolean expectResponseBody = true;
        if ("HEAD".equals(httpRequest.getMethod()) || "CONNECT".equals(httpRequest.getMethod())) {
            expectResponseBody = false;
        }
        this.httpParser.reset(expectResponseBody);
    }

    @Override
    boolean processRead(ByteBuffer data) {
        boolean headerParsed = this.httpParser.isHeaderParsed();
        try {
            this.httpParser.parse(data);
        }
        catch (ParseException e) {
            this.onError(e);
        }
        if (!headerParsed && this.httpParser.isHeaderParsed()) {
            HttpResponse httpResponse = this.httpParser.getHttpResponse();
            this.upstreamFilter.onRead(httpResponse);
        }
        return false;
    }

    private void addTransportHeaders(HttpRequest httpRequest) {
        if (httpRequest.getBodyMode() == HttpRequest.BodyMode.BUFFERED) {
            httpRequest.addHeaderIfNotPresent(Constants.CONTENT_LENGTH, Integer.toString(httpRequest.getBodySize()));
        }
        URI uri = httpRequest.getUri();
        int port = Utils.getPort(uri);
        httpRequest.addHeaderIfNotPresent(Constants.HOST, uri.getHost() + ":" + port);
        if (httpRequest.getBodyMode() == HttpRequest.BodyMode.CHUNKED) {
            httpRequest.addHeaderIfNotPresent(Constants.TRANSFER_ENCODING_HEADER, Constants.TRANSFER_ENCODING_CHUNKED);
        }
        if (httpRequest.getBodyMode() == HttpRequest.BodyMode.NONE) {
            httpRequest.addHeaderIfNotPresent("Content-Length", Integer.toString(0));
        }
    }
}

