/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jdk.connector;

import java.io.IOException;
import java.io.OutputStream;

class InterceptingOutputStream
extends OutputStream {
    private final OutputStream wrappedStream;
    private final FirstCallListener firstCallListener;
    private volatile boolean listenerInvoked = false;

    InterceptingOutputStream(OutputStream wrappedStream, FirstCallListener firstCallListener) {
        this.wrappedStream = wrappedStream;
        this.firstCallListener = firstCallListener;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.tryInvokingListener();
        this.wrappedStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.tryInvokingListener();
        this.wrappedStream.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.tryInvokingListener();
        this.wrappedStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.tryInvokingListener();
        this.wrappedStream.close();
    }

    @Override
    public void write(int b) throws IOException {
        this.tryInvokingListener();
        this.wrappedStream.write(b);
    }

    private void tryInvokingListener() {
        if (!this.listenerInvoked) {
            this.listenerInvoked = true;
            this.firstCallListener.onInvoked();
        }
    }

    static interface FirstCallListener {
        public void onInvoked();
    }
}

