/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jdk.connector;

import java.nio.charset.Charset;
import org.glassfish.jersey.internal.util.Base64;
import org.glassfish.jersey.jdk.connector.LocalizationMessages;
import org.glassfish.jersey.jdk.connector.ProxyAuthenticationException;

class ProxyBasicAuthenticator {
    private static final Charset CHARACTER_SET = Charset.forName("iso-8859-1");

    ProxyBasicAuthenticator() {
    }

    static String generateAuthorizationHeader(String userName, String password) throws ProxyAuthenticationException {
        if (userName == null) {
            throw new ProxyAuthenticationException(LocalizationMessages.PROXY_USER_NAME_MISSING());
        }
        if (password == null) {
            throw new ProxyAuthenticationException(LocalizationMessages.PROXY_PASSWORD_MISSING());
        }
        byte[] prefix = (userName + ":").getBytes(CHARACTER_SET);
        byte[] passwordBytes = password.getBytes(CHARACTER_SET);
        byte[] usernamePassword = new byte[prefix.length + passwordBytes.length];
        System.arraycopy(prefix, 0, usernamePassword, 0, prefix.length);
        System.arraycopy(passwordBytes, 0, usernamePassword, prefix.length, passwordBytes.length);
        return "Basic " + Base64.encodeAsString((byte[])usernamePassword);
    }
}

