/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jdk.connector;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.jersey.jdk.connector.LocalizationMessages;
import org.glassfish.jersey.jdk.connector.ProxyAuthenticationException;

class ProxyDigestAuthenticator {
    private static final Charset CHARACTER_SET = Charset.forName("iso-8859-1");
    private static final Logger logger = Logger.getLogger(ProxyDigestAuthenticator.class.getName());
    private static final char[] HEX_ARRAY = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final Pattern KEY_VALUE_PAIR_PATTERN = Pattern.compile("(\\w+)\\s*=\\s*(\"([^\"]+)\"|(\\w+))\\s*,?\\s*");
    private static final int CLIENT_NONCE_BYTE_COUNT = 4;
    private SecureRandom randomGenerator;

    ProxyDigestAuthenticator() {
        try {
            this.randomGenerator = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            logger.config("No such algorithm to generate authorization digest http header." + e);
        }
    }

    String generateAuthorizationHeader(URI uri, String method, String authenticateHeader, String userName, String password) throws ProxyAuthenticationException {
        DigestScheme digestScheme;
        if (userName == null) {
            throw new ProxyAuthenticationException(LocalizationMessages.PROXY_USER_NAME_MISSING());
        }
        if (password == null) {
            throw new ProxyAuthenticationException(LocalizationMessages.PROXY_PASSWORD_MISSING());
        }
        try {
            digestScheme = this.parseAuthHeaders(authenticateHeader);
        }
        catch (IOException e) {
            throw new ProxyAuthenticationException(e.getMessage());
        }
        if (digestScheme == null) {
            throw new ProxyAuthenticationException(LocalizationMessages.PROXY_FAIL_AUTH_HEADER());
        }
        return this.createNextAuthToken(digestScheme, uri.toString(), method, userName, password);
    }

    private DigestScheme parseAuthHeaders(String authHeader) throws IOException {
        if (authHeader == null) {
            return null;
        }
        String[] parts = authHeader.trim().split("\\s+", 2);
        if (parts.length != 2) {
            return null;
        }
        if (!parts[0].toLowerCase().equals("digest")) {
            return null;
        }
        String realm = null;
        String nonce = null;
        String opaque = null;
        QOP qop = QOP.UNSPECIFIED;
        Algorithm algorithm = Algorithm.UNSPECIFIED;
        boolean stale = false;
        Matcher match = KEY_VALUE_PAIR_PATTERN.matcher(parts[1]);
        while (match.find()) {
            String val;
            int nbGroups = match.groupCount();
            if (nbGroups != 4) continue;
            String key = match.group(1);
            String valNoQuotes = match.group(3);
            String valQuotes = match.group(4);
            String string = val = valNoQuotes == null ? valQuotes : valNoQuotes;
            if (key.equals("qop")) {
                qop = QOP.parse(val);
                continue;
            }
            if (key.equals("realm")) {
                realm = val;
                continue;
            }
            if (key.equals("nonce")) {
                nonce = val;
                continue;
            }
            if (key.equals("opaque")) {
                opaque = val;
                continue;
            }
            if (key.equals("stale")) {
                stale = Boolean.parseBoolean(val);
                continue;
            }
            if (!key.equals("algorithm")) continue;
            algorithm = Algorithm.parse(val);
        }
        return new DigestScheme(realm, nonce, opaque, qop, algorithm, stale);
    }

    private String createNextAuthToken(DigestScheme ds, String uri, String method, String userName, String password) throws ProxyAuthenticationException {
        String response;
        StringBuilder sb = new StringBuilder(100);
        sb.append("Digest ");
        ProxyDigestAuthenticator.append(sb, "username", userName);
        ProxyDigestAuthenticator.append(sb, "realm", ds.getRealm());
        ProxyDigestAuthenticator.append(sb, "nonce", ds.getNonce());
        ProxyDigestAuthenticator.append(sb, "opaque", ds.getOpaque());
        ProxyDigestAuthenticator.append(sb, "algorithm", ds.getAlgorithm().toString(), false);
        ProxyDigestAuthenticator.append(sb, "qop", ds.getQop().toString(), false);
        ProxyDigestAuthenticator.append(sb, "uri", uri);
        String ha1 = ds.getAlgorithm().equals((Object)Algorithm.MD5_SESS) ? ProxyDigestAuthenticator.md5(ProxyDigestAuthenticator.md5(userName, ds.getRealm(), password)) : ProxyDigestAuthenticator.md5(userName, ds.getRealm(), password);
        String ha2 = ProxyDigestAuthenticator.md5(method, uri);
        if (ds.getQop().equals((Object)QOP.UNSPECIFIED)) {
            response = ProxyDigestAuthenticator.md5(ha1, ds.getNonce(), ha2);
        } else {
            String cnonce = this.randomBytes(4);
            ProxyDigestAuthenticator.append(sb, "cnonce", cnonce);
            String nc = String.format("%08x", ds.incrementCounter());
            ProxyDigestAuthenticator.append(sb, "nc", nc, false);
            response = ProxyDigestAuthenticator.md5(ha1, ds.getNonce(), nc, cnonce, ds.getQop().toString(), ha2);
        }
        ProxyDigestAuthenticator.append(sb, "response", response);
        return sb.toString();
    }

    private static void append(StringBuilder sb, String key, String value, boolean useQuote) {
        if (value == null) {
            return;
        }
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) != ' ') {
            sb.append(", ");
        }
        sb.append(key);
        sb.append('=');
        if (useQuote) {
            sb.append('\"');
        }
        sb.append(value);
        if (useQuote) {
            sb.append('\"');
        }
    }

    private static void append(StringBuilder sb, String key, String value) {
        ProxyDigestAuthenticator.append(sb, key, value, true);
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    private static String md5(String ... tokens) throws ProxyAuthenticationException {
        MessageDigest md;
        StringBuilder sb = new StringBuilder(100);
        for (String token : tokens) {
            if (sb.length() > 0) {
                sb.append(':');
            }
            sb.append(token);
        }
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new ProxyAuthenticationException(ex.getMessage());
        }
        md.update(sb.toString().getBytes(CHARACTER_SET), 0, sb.length());
        byte[] md5hash = md.digest();
        return ProxyDigestAuthenticator.bytesToHex(md5hash);
    }

    private String randomBytes(int nbBytes) {
        byte[] bytes = new byte[nbBytes];
        this.randomGenerator.nextBytes(bytes);
        return ProxyDigestAuthenticator.bytesToHex(bytes);
    }

    final class DigestScheme {
        private final String realm;
        private final String nonce;
        private final String opaque;
        private final Algorithm algorithm;
        private final QOP qop;
        private final boolean stale;
        private volatile int nc;

        DigestScheme(String realm, String nonce, String opaque, QOP qop, Algorithm algorithm, boolean stale) {
            this.realm = realm;
            this.nonce = nonce;
            this.opaque = opaque;
            this.qop = qop;
            this.algorithm = algorithm;
            this.stale = stale;
            this.nc = 0;
        }

        public int incrementCounter() {
            return ++this.nc;
        }

        public String getNonce() {
            return this.nonce;
        }

        public String getRealm() {
            return this.realm;
        }

        public String getOpaque() {
            return this.opaque;
        }

        public Algorithm getAlgorithm() {
            return this.algorithm;
        }

        public QOP getQop() {
            return this.qop;
        }

        public boolean isStale() {
            return this.stale;
        }

        public int getNc() {
            return this.nc;
        }
    }

    static enum Algorithm {
        UNSPECIFIED(null),
        MD5("MD5"),
        MD5_SESS("MD5-sess");

        private final String md;

        private Algorithm(String md) {
            this.md = md;
        }

        public String toString() {
            return this.md;
        }

        public static Algorithm parse(String val) {
            if (val == null || val.isEmpty()) {
                return UNSPECIFIED;
            }
            if ((val = val.trim()).contains(Algorithm.MD5_SESS.md) || val.contains(Algorithm.MD5_SESS.md.toLowerCase())) {
                return MD5_SESS;
            }
            return MD5;
        }
    }

    private static enum QOP {
        UNSPECIFIED(null),
        AUTH("auth");

        private final String qop;

        private QOP(String qop) {
            this.qop = qop;
        }

        public String toString() {
            return this.qop;
        }

        public static QOP parse(String val) {
            if (val == null || val.isEmpty()) {
                return UNSPECIFIED;
            }
            if (val.contains("auth")) {
                return AUTH;
            }
            throw new UnsupportedOperationException(LocalizationMessages.PROXY_QOP_NO_SUPPORTED(val));
        }
    }
}

