/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jdk.connector;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.jersey.jdk.connector.AsynchronousBodyInputStream;
import org.glassfish.jersey.jdk.connector.CompletionHandler;
import org.glassfish.jersey.jdk.connector.ConnectorConfiguration;
import org.glassfish.jersey.jdk.connector.Constants;
import org.glassfish.jersey.jdk.connector.HttpConnectionPool;
import org.glassfish.jersey.jdk.connector.HttpRequest;
import org.glassfish.jersey.jdk.connector.HttpResponse;
import org.glassfish.jersey.jdk.connector.LocalizationMessages;
import org.glassfish.jersey.jdk.connector.ReadListener;
import org.glassfish.jersey.jdk.connector.RedirectException;

class RedirectHandler {
    private static final Set<Integer> REDIRECT_STATUS_CODES = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(301, 302, 303, 307, 308)));
    private final int maxRedirects;
    private final boolean followRedirects;
    private final Set<URI> redirectUriHistory;
    private final HttpConnectionPool httpConnectionPool;
    private final HttpRequest originalHttpRequest;
    private volatile URI lastRequestUri = null;

    RedirectHandler(HttpConnectionPool httpConnectionPool, HttpRequest originalHttpRequest, ConnectorConfiguration connectorConfiguration) {
        this.followRedirects = connectorConfiguration.getFollowRedirects();
        this.maxRedirects = connectorConfiguration.getMaxRedirects();
        this.httpConnectionPool = httpConnectionPool;
        this.originalHttpRequest = originalHttpRequest;
        this.redirectUriHistory = new HashSet<URI>(this.maxRedirects);
        this.lastRequestUri = originalHttpRequest.getUri();
    }

    void handleRedirects(final HttpResponse httpResponse, final CompletionHandler<HttpResponse> completionHandler) {
        if (!this.followRedirects) {
            completionHandler.completed(httpResponse);
            return;
        }
        if (!REDIRECT_STATUS_CODES.contains(httpResponse.getStatusCode())) {
            completionHandler.completed(httpResponse);
            return;
        }
        if (httpResponse.getStatusCode() != 303 && !"HEAD".equals(this.originalHttpRequest.getMethod()) && !"GET".equals(this.originalHttpRequest.getMethod())) {
            completionHandler.completed(httpResponse);
            return;
        }
        this.consumeBodyIfPresent(httpResponse, new CompletionHandler<Void>(){

            @Override
            public void failed(Throwable throwable) {
                completionHandler.failed(throwable);
            }

            @Override
            public void completed(Void r) {
                RedirectHandler.this.doRedirect(httpResponse, new CompletionHandler<HttpResponse>(){

                    @Override
                    public void failed(Throwable throwable) {
                        completionHandler.failed(throwable);
                    }

                    @Override
                    public void completed(HttpResponse result) {
                        RedirectHandler.this.handleRedirects(result, completionHandler);
                    }
                });
            }
        });
    }

    private void doRedirect(HttpResponse httpResponse, CompletionHandler<HttpResponse> completionHandler) {
        boolean alreadyRequested;
        URI location;
        String locationString = null;
        List<String> locationHeader = httpResponse.getHeader("Location");
        if (locationHeader != null && !locationHeader.isEmpty()) {
            locationString = locationHeader.get(0);
        }
        if (locationString == null || locationString.isEmpty()) {
            completionHandler.failed(new RedirectException(LocalizationMessages.REDIRECT_NO_LOCATION()));
            return;
        }
        try {
            location = new URI(locationString);
            if (!location.isAbsolute()) {
                URI baseUri = this.lastRequestUri;
                location = baseUri.resolve(location.normalize());
            }
        }
        catch (URISyntaxException e) {
            completionHandler.failed(new RedirectException(LocalizationMessages.REDIRECT_ERROR_DETERMINING_LOCATION(), e));
            return;
        }
        boolean bl = alreadyRequested = !this.redirectUriHistory.add(location);
        if (alreadyRequested) {
            completionHandler.failed(new RedirectException(LocalizationMessages.REDIRECT_INFINITE_LOOP()));
            return;
        }
        if (this.redirectUriHistory.size() > this.maxRedirects) {
            completionHandler.failed(new RedirectException(LocalizationMessages.REDIRECT_LIMIT_REACHED(this.maxRedirects)));
            return;
        }
        String method = this.originalHttpRequest.getMethod();
        Map<String, List<String>> headers = this.originalHttpRequest.getHeaders();
        if (httpResponse.getStatusCode() == 303 && !method.equals("HEAD")) {
            method = "GET";
            headers.remove(Constants.CONTENT_LENGTH);
            headers.remove(Constants.TRANSFER_ENCODING_HEADER);
        }
        HttpRequest httpRequest = HttpRequest.createBodyless(method, location);
        httpRequest.getHeaders().putAll(headers);
        this.lastRequestUri = location;
        this.httpConnectionPool.send(httpRequest, completionHandler);
    }

    private void consumeBodyIfPresent(HttpResponse response, final CompletionHandler<Void> completionHandler) {
        final AsynchronousBodyInputStream bodyStream = response.getBodyStream();
        bodyStream.setReadListener(new ReadListener(){

            @Override
            public void onDataAvailable() {
                while (bodyStream.isReady()) {
                    try {
                        bodyStream.read();
                    }
                    catch (IOException e) {
                        completionHandler.failed(e);
                    }
                }
            }

            @Override
            public void onAllDataRead() {
                completionHandler.completed(null);
            }

            @Override
            public void onError(Throwable t) {
                completionHandler.failed(t);
            }
        });
    }

    URI getLastRequestUri() {
        return this.lastRequestUri;
    }
}

