/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jdk.connector;

import java.net.URI;
import java.nio.ByteBuffer;

public class Utils {
    static ByteBuffer appendBuffers(ByteBuffer buffer, ByteBuffer buffer1, int incomingBufferSize, int BUFFER_STEP_SIZE) {
        int limit = buffer.limit();
        int capacity = buffer.capacity();
        int remaining = buffer.remaining();
        int len = buffer1.remaining();
        if (len < capacity - limit) {
            buffer.mark();
            buffer.position(limit);
            buffer.limit(capacity);
            buffer.put(buffer1);
            buffer.limit(limit + len);
            buffer.reset();
            return buffer;
        }
        if (remaining + len < capacity) {
            buffer.compact();
            buffer.put(buffer1);
            buffer.flip();
            return buffer;
        }
        int newSize = remaining + len;
        if (newSize > incomingBufferSize) {
            throw new IllegalArgumentException("Buffer overflow");
        }
        int roundedSize = newSize % BUFFER_STEP_SIZE > 0 ? (newSize / BUFFER_STEP_SIZE + 1) * BUFFER_STEP_SIZE : newSize;
        ByteBuffer result = ByteBuffer.allocate(roundedSize > incomingBufferSize ? newSize : roundedSize);
        result.put(buffer);
        result.put(buffer1);
        result.flip();
        return result;
    }

    static ByteBuffer split(ByteBuffer buffer, int position) {
        int bytesLength = position - buffer.position();
        byte[] bytes = new byte[bytesLength];
        buffer.get(bytes);
        return ByteBuffer.wrap(bytes);
    }

    static int getPort(URI uri) {
        if (uri.getPort() != -1) {
            return uri.getPort();
        }
        if ("https".equals(uri.getScheme())) {
            return 443;
        }
        return 80;
    }
}

