
package org.glassfish.jersey.inject.cdi.se;

import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("org.glassfish.jersey.inject.cdi.se.localization");
    private final static Localizer localizer = new Localizer();

    public static Localizable localizableCDI_2_PROVIDER_NOT_REGISTRABLE(Object arg0) {
        return messageFactory.getMessage("cdi2.provider.not.registrable", arg0);
    }

    /**
     * Provider registered to CdiInjectionManager cannot be process because of incompatible type: {0}.
     * 
     */
    public static String CDI_2_PROVIDER_NOT_REGISTRABLE(Object arg0) {
        return localizer.localize(localizableCDI_2_PROVIDER_NOT_REGISTRABLE(arg0));
    }

}
