
package org.glassfish.jersey.inject.cdi.se;

import java.util.Locale;
import java.util.ResourceBundle;
import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory.ResourceBundleSupplier;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static String BUNDLE_NAME = "org.glassfish.jersey.inject.cdi.se.localization";
    private final static LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new LocalizationMessages.BundleSupplier());
    private final static Localizer LOCALIZER = new Localizer();

    public static Localizable localizableCDI_2_PROVIDER_NOT_REGISTRABLE(Object arg0) {
        return MESSAGE_FACTORY.getMessage("cdi2.provider.not.registrable", arg0);
    }

    /**
     * Provider registered to CdiInjectionManager cannot be process because of incompatible type: {0}.
     * 
     */
    public static String CDI_2_PROVIDER_NOT_REGISTRABLE(Object arg0) {
        return LOCALIZER.localize(localizableCDI_2_PROVIDER_NOT_REGISTRABLE(arg0));
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
